/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.config;

import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.appengine.config.AppengineConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.security.AppengineNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.credentials.CredentialsTypeBaseConfiguration;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.poller.Poller;
import com.netflix.spinnaker.kork.configserver.ConfigFileService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppengineCredentialsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AppengineCredentialsConfiguration.class);

    @Bean
    public CredentialsTypeBaseConfiguration<AppengineNamedAccountCredentials, AppengineConfigurationProperties.ManagedAccount> appengineCredentialsProperties(ApplicationContext applicationContext, AppengineConfigurationProperties configurationProperties, AppengineJobExecutor jobExecutor, ConfigFileService configFileService, String clouddriverUserAgentApplicationName) {
        return new CredentialsTypeBaseConfiguration(applicationContext, CredentialsTypeProperties.builder().type("appengine").credentialsDefinitionClass(AppengineConfigurationProperties.ManagedAccount.class).credentialsClass(AppengineNamedAccountCredentials.class).credentialsParser(a -> {
            try {
                String gcloudPath = configurationProperties.getGcloudPath();
                if (StringUtils.isEmpty((CharSequence)gcloudPath)) {
                    gcloudPath = "gcloud";
                }
                a.initialize(jobExecutor, gcloudPath);
                String jsonKey = configFileService.getContents(a.getJsonPath());
                return new AppengineNamedAccountCredentials.Builder().name(a.getName()).environment(StringUtils.isEmpty((CharSequence)a.getEnvironment()) ? a.getName() : a.getEnvironment()).accountType(StringUtils.isEmpty((CharSequence)a.getAccountType()) ? a.getName() : a.getAccountType()).project(a.getProject()).jsonKey(jsonKey).applicationName(clouddriverUserAgentApplicationName).gcloudPath(gcloudPath).jsonPath(a.getJsonPath()).requiredGroupMembership(a.getRequiredGroupMembership()).permissions(a.getPermissions().build()).serviceAccountEmail(a.getComputedServiceAccountEmail()).localRepositoryDirectory(a.getLocalRepositoryDirectory()).gitHttpsUsername(a.getGitHttpsUsername()).gitHttpsPassword(a.getGitHttpsPassword()).githubOAuthAccessToken(a.getGithubOAuthAccessToken()).sshPrivateKeyFilePath(a.getSshPrivateKeyFilePath()).sshPrivateKeyPassphrase(a.getSshPrivateKeyPassphrase()).sshKnownHostsFilePath(a.getSshKnownHostsFilePath()).sshTrustUnknownHosts(a.isSshTrustUnknownHosts()).gcloudReleaseTrack(a.getGcloudReleaseTrack()).services(a.getServices()).versions(a.getVersions()).omitServices(a.getOmitServices()).omitVersions(a.getOmitVersions()).cachingIntervalSeconds(a.getCachingIntervalSeconds()).build();
            }
            catch (Exception e) {
                log.info(String.format("Could not load account %s for App Engine", a.getName()), (Throwable)e);
                return null;
            }
        }).defaultCredentialsSource(configurationProperties::getAccounts).build());
    }

    @Bean
    public CredentialsInitializerSynchronizable appengineCredentialsInitializerSynchronizable(AbstractCredentialsLoader<AppengineNamedAccountCredentials> loader) {
        final Poller poller = new Poller(loader);
        return new CredentialsInitializerSynchronizable(){

            public void synchronize() {
                poller.run();
            }
        };
    }
}

