/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.model;

import com.google.api.services.appengine.v1.model.Version;
import com.netflix.spinnaker.clouddriver.appengine.AppengineCloudProvider;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineInstance;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineModelUtil;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineScalingPolicy;
import com.netflix.spinnaker.clouddriver.appengine.model.ScalingPolicyType;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode(includes={"name", "account"})
public class AppengineServerGroup
implements ServerGroup,
Serializable,
GroovyObject {
    private String name;
    private final String type;
    private final String cloudProvider;
    private String account;
    private String region;
    private Set<String> zones;
    private Set<AppengineInstance> instances;
    private Set<String> loadBalancers;
    private Long createdTime;
    private Map<String, Object> launchConfig;
    private Set<String> securityGroups;
    private Boolean disabled;
    private AppengineScalingPolicy scalingPolicy;
    private ServingStatus servingStatus;
    private Environment env;
    private String httpUrl;
    private String httpsUrl;
    private String instanceClass;
    private Boolean allowsGradualTrafficMigration;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AppengineServerGroup() {
        MetaClass metaClass;
        Map map;
        String string;
        String string2;
        this.type = string2 = AppengineCloudProvider.getID();
        this.cloudProvider = string = AppengineCloudProvider.getID();
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.zones = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.loadBalancers = (Set)ScriptBytecodeAdapter.castToType((Object)list2, Set.class);
        this.launchConfig = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list3, Set.class);
        boolean bl = true;
        this.disabled = bl;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public AppengineServerGroup(Version version, String account, String region, String loadBalancerName, Boolean isDisabled) {
        Boolean bl;
        Set set;
        String string;
        String string2;
        String string3;
        AppengineScalingPolicy appengineScalingPolicy;
        Boolean bl2;
        Long l;
        Set set2;
        String string4;
        String string5;
        String string6;
        MetaClass metaClass;
        Map map;
        String string7;
        String string8;
        this.type = string8 = AppengineCloudProvider.getID();
        this.cloudProvider = string7 = AppengineCloudProvider.getID();
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.zones = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.loadBalancers = (Set)ScriptBytecodeAdapter.castToType((Object)list2, Set.class);
        this.launchConfig = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list3, Set.class);
        boolean bl3 = true;
        this.disabled = bl3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.account = string6 = account;
        this.region = string5 = region;
        this.name = string4 = version.getId();
        this.loadBalancers = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancerName}), Set.class);
        this.createdTime = l = AppengineModelUtil.translateTime(version.getCreateTime());
        this.disabled = bl2 = isDisabled;
        this.scalingPolicy = appengineScalingPolicy = AppengineModelUtil.getScalingPolicy(version);
        ServingStatus servingStatus = DefaultTypeTransformation.booleanUnbox((Object)version.getServingStatus()) ? ServingStatus.valueOf(version.getServingStatus()) : null;
        this.servingStatus = (ServingStatus)ShortTypeHandling.castToEnum((Object)((Object)servingStatus), ServingStatus.class);
        Environment environment = DefaultTypeTransformation.booleanUnbox((Object)version.getEnv()) ? Environment.valueOf(version.getEnv().toUpperCase()) : null;
        this.env = (Environment)ShortTypeHandling.castToEnum((Object)((Object)environment), Environment.class);
        this.httpUrl = string3 = AppengineModelUtil.getHttpUrl(version.getName());
        this.httpsUrl = string2 = AppengineModelUtil.getHttpsUrl(version.getName());
        this.instanceClass = string = version.getInstanceClass();
        String string9 = this.instanceClass;
        ScriptBytecodeAdapter.setProperty((Object)string9, null, this.launchConfig, (String)"instanceType");
        this.zones = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{region}), Set.class);
        this.allowsGradualTrafficMigration = bl = AppengineServerGroup.versionAllowsGradualTrafficMigration(version);
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        ServerGroup.InstanceCounts instanceCounts = new ServerGroup.InstanceCounts();
        int n = 0;
        instanceCounts.setDown(Integer.valueOf(n));
        Set<AppengineInstance> set = this.instances;
        public final class _getInstanceCounts_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((AppengineInstance)it).getHealthState(), (Object)HealthState.OutOfService);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n2 = (Integer)ScriptBytecodeAdapter.castToType(set != null ? (Number)DefaultGroovyMethods.count(set, (Closure)new _getInstanceCounts_closure1(this, this)) : (Number)null, Integer.class);
        Integer n3 = DefaultTypeTransformation.booleanUnbox((Object)n2) ? n2 : Integer.valueOf(0);
        instanceCounts.setOutOfService(n3);
        Set<AppengineInstance> set2 = this.instances;
        public final class _getInstanceCounts_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((AppengineInstance)it).getHealthState(), (Object)HealthState.Up);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n4 = (Integer)ScriptBytecodeAdapter.castToType(set2 != null ? (Number)DefaultGroovyMethods.count(set2, (Closure)new _getInstanceCounts_closure2(this, this)) : (Number)null, Integer.class);
        Integer n5 = DefaultTypeTransformation.booleanUnbox((Object)n4) ? n4 : Integer.valueOf(0);
        instanceCounts.setUp(n5);
        int n6 = 0;
        instanceCounts.setStarting(Integer.valueOf(n6));
        int n7 = 0;
        instanceCounts.setUnknown(Integer.valueOf(n7));
        Set<AppengineInstance> set3 = this.instances;
        Integer n8 = set3 != null ? Integer.valueOf(set3.size()) : null;
        instanceCounts.setTotal(n8);
        return instanceCounts;
    }

    public Object update(Version version, String account, String region, String loadBalancerName, Boolean isDisabled) {
        Boolean bl;
        Set set;
        String string;
        String string2;
        String string3;
        AppengineScalingPolicy appengineScalingPolicy;
        Boolean bl2;
        Long l;
        String string4;
        String string5;
        String string6;
        this.account = string6 = account;
        this.region = string5 = region;
        this.name = string4 = version.getId();
        this.loadBalancers.add(loadBalancerName);
        this.createdTime = l = AppengineModelUtil.translateTime(version.getCreateTime());
        this.disabled = bl2 = isDisabled;
        this.scalingPolicy = appengineScalingPolicy = AppengineModelUtil.getScalingPolicy(version);
        ServingStatus servingStatus = DefaultTypeTransformation.booleanUnbox((Object)version.getServingStatus()) ? ServingStatus.valueOf(version.getServingStatus()) : null;
        this.servingStatus = (ServingStatus)ShortTypeHandling.castToEnum((Object)((Object)servingStatus), ServingStatus.class);
        Environment environment = DefaultTypeTransformation.booleanUnbox((Object)version.getEnv()) ? Environment.valueOf(version.getEnv().toUpperCase()) : null;
        this.env = (Environment)ShortTypeHandling.castToEnum((Object)((Object)environment), Environment.class);
        this.httpUrl = string3 = AppengineModelUtil.getHttpUrl(version.getName());
        this.httpsUrl = string2 = AppengineModelUtil.getHttpsUrl(version.getName());
        this.instanceClass = string = version.getInstanceClass();
        String string7 = this.instanceClass;
        ScriptBytecodeAdapter.setProperty((Object)string7, null, this.launchConfig, (String)"instanceType");
        this.zones = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{region}), Set.class);
        this.allowsGradualTrafficMigration = bl = AppengineServerGroup.versionAllowsGradualTrafficMigration(version);
        return bl;
    }

    public ServerGroup.Capacity getCapacity() {
        ScalingPolicyType scalingPolicyType;
        Set<AppengineInstance> set = this.instances;
        Integer n = set != null ? Integer.valueOf(set.size()) : null;
        Integer instanceCount = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0);
        AppengineScalingPolicy appengineScalingPolicy = this.scalingPolicy;
        ScalingPolicyType scalingPolicyType2 = scalingPolicyType = appengineScalingPolicy != null ? appengineScalingPolicy.getType() : null;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)scalingPolicyType), (Object)((Object)ScalingPolicyType.AUTOMATIC))) {
            Integer min = this.computeMinForAutomaticScaling(this.scalingPolicy);
            Integer max = this.computeMaxForAutomaticScaling(this.scalingPolicy);
            ServerGroup.Capacity capacity = new ServerGroup.Capacity();
            Integer n2 = min;
            capacity.setMin(n2);
            Integer n3 = max;
            capacity.setMax(n3);
            Integer n4 = min;
            capacity.setDesired(n4);
            return capacity;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)scalingPolicyType), (Object)((Object)ScalingPolicyType.BASIC))) {
            Integer desired = ScriptBytecodeAdapter.compareEqual((Object)((Object)this.servingStatus), (Object)((Object)ServingStatus.SERVING)) ? instanceCount : Integer.valueOf(0);
            ServerGroup.Capacity capacity = new ServerGroup.Capacity();
            int n5 = 0;
            capacity.setMin(Integer.valueOf(n5));
            Integer n6 = this.scalingPolicy.getMaxInstances();
            capacity.setMax(n6);
            Integer n7 = desired;
            capacity.setDesired(n7);
            return capacity;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)scalingPolicyType), (Object)((Object)ScalingPolicyType.MANUAL))) {
            Integer desired = ScriptBytecodeAdapter.compareEqual((Object)((Object)this.servingStatus), (Object)((Object)ServingStatus.SERVING)) ? this.scalingPolicy.getInstances() : Integer.valueOf(0);
            ServerGroup.Capacity capacity = new ServerGroup.Capacity();
            int n8 = 0;
            capacity.setMin(Integer.valueOf(n8));
            Integer n9 = this.scalingPolicy.getInstances();
            capacity.setMax(n9);
            Integer n10 = desired;
            capacity.setDesired(n10);
            return capacity;
        }
        ServerGroup.Capacity capacity = new ServerGroup.Capacity();
        Integer n11 = instanceCount;
        capacity.setMin(n11);
        Integer n12 = instanceCount;
        capacity.setMax(n12);
        Integer n13 = instanceCount;
        capacity.setDesired(n13);
        return capacity;
    }

    public Integer computeMinForAutomaticScaling(AppengineScalingPolicy scalingPolicy) {
        Set<AppengineInstance> set = this.instances;
        Integer n = set != null ? Integer.valueOf(set.size()) : null;
        Integer instanceCount = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.servingStatus), (Object)((Object)ServingStatus.SERVING))) {
            public final class _computeMinForAutomaticScaling_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _computeMinForAutomaticScaling_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it != null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _computeMinForAutomaticScaling_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List candidateMinValues = DefaultGroovyMethods.findAll((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{scalingPolicy.getMinIdleInstances(), scalingPolicy.getMinTotalInstances(), instanceCount}), (Closure)new _computeMinForAutomaticScaling_closure3(this, this));
            return (Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.min((Iterable)candidateMinValues), Integer.class);
        }
        return 0;
    }

    public Integer computeMaxForAutomaticScaling(AppengineScalingPolicy scalingPolicy) {
        Set<AppengineInstance> set = this.instances;
        Integer n = set != null ? Integer.valueOf(set.size()) : null;
        Integer instanceCount = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.servingStatus), (Object)((Object)ServingStatus.SERVING))) {
            public final class _computeMaxForAutomaticScaling_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _computeMaxForAutomaticScaling_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it != null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _computeMaxForAutomaticScaling_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List candidateMaxValues = DefaultGroovyMethods.findAll((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{scalingPolicy.getMaxIdleInstances(), scalingPolicy.getMaxTotalInstances(), instanceCount}), (Closure)new _computeMaxForAutomaticScaling_closure4(this, this));
            return (Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.max((Iterable)candidateMaxValues), Integer.class);
        }
        return instanceCount;
    }

    public static Boolean versionAllowsGradualTrafficMigration(Version version) {
        String string = version.getEnv();
        boolean inStandardEnvironment = ScriptBytecodeAdapter.compareNotEqual((Object)(string != null ? string.toUpperCase() : null), (Object)"FLEXIBLE");
        List list = version.getInboundServices();
        boolean warmupRequestsConfigured = (DefaultTypeTransformation.booleanUnbox((Object)list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0])).contains("INBOUND_SERVICE_WARMUP");
        boolean usesAutomaticScaling = ScriptBytecodeAdapter.compareEqual((Object)((Object)AppengineModelUtil.getScalingPolicy(version).getType()), (Object)((Object)ScalingPolicyType.AUTOMATIC));
        return inStandardEnvironment && warmupRequestsConfigured && usesAutomaticScaling;
    }

    public ServerGroup.ImageSummary getImageSummary() {
        return (ServerGroup.ImageSummary)ScriptBytecodeAdapter.castToType(null, ServerGroup.ImageSummary.class);
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        return (ServerGroup.ImagesSummary)ScriptBytecodeAdapter.castToType(null, ServerGroup.ImagesSummary.class);
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AppengineServerGroup.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!(this.getName() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getName());
        }
        if (!(this.getAccount() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getAccount());
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof AppengineServerGroup;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppengineServerGroup)) {
            return false;
        }
        AppengineServerGroup otherTyped = (AppengineServerGroup)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getName(), (Object)otherTyped.getName())) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getAccount(), (Object)otherTyped.getAccount()));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AppengineServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AppengineServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AppengineServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public final String getType() {
        return this.type;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public void setAccount(String string) {
        this.account = string;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public void setRegion(String string) {
        this.region = string;
    }

    @Generated
    public Set<String> getZones() {
        return this.zones;
    }

    @Generated
    public void setZones(Set<String> set) {
        this.zones = set;
    }

    @Generated
    public Set<AppengineInstance> getInstances() {
        return this.instances;
    }

    @Generated
    public void setInstances(Set<AppengineInstance> set) {
        this.instances = set;
    }

    @Generated
    public Set<String> getLoadBalancers() {
        return this.loadBalancers;
    }

    @Generated
    public void setLoadBalancers(Set<String> set) {
        this.loadBalancers = set;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public void setCreatedTime(Long l) {
        this.createdTime = l;
    }

    @Generated
    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    @Generated
    public void setLaunchConfig(Map<String, Object> map) {
        this.launchConfig = map;
    }

    @Generated
    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public void setSecurityGroups(Set<String> set) {
        this.securityGroups = set;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public void setDisabled(Boolean bl) {
        this.disabled = bl;
    }

    @Generated
    public AppengineScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    @Generated
    public void setScalingPolicy(AppengineScalingPolicy appengineScalingPolicy) {
        this.scalingPolicy = appengineScalingPolicy;
    }

    @Generated
    public ServingStatus getServingStatus() {
        return this.servingStatus;
    }

    @Generated
    public void setServingStatus(ServingStatus servingStatus) {
        this.servingStatus = servingStatus;
    }

    @Generated
    public Environment getEnv() {
        return this.env;
    }

    @Generated
    public void setEnv(Environment environment) {
        this.env = environment;
    }

    @Generated
    public String getHttpUrl() {
        return this.httpUrl;
    }

    @Generated
    public void setHttpUrl(String string) {
        this.httpUrl = string;
    }

    @Generated
    public String getHttpsUrl() {
        return this.httpsUrl;
    }

    @Generated
    public void setHttpsUrl(String string) {
        this.httpsUrl = string;
    }

    @Generated
    public String getInstanceClass() {
        return this.instanceClass;
    }

    @Generated
    public void setInstanceClass(String string) {
        this.instanceClass = string;
    }

    @Generated
    public Boolean getAllowsGradualTrafficMigration() {
        return this.allowsGradualTrafficMigration;
    }

    @Generated
    public void setAllowsGradualTrafficMigration(Boolean bl) {
        this.allowsGradualTrafficMigration = bl;
    }

    public static final class ServingStatus
    extends Enum<ServingStatus>
    implements GroovyObject {
        public static final /* enum */ ServingStatus SERVING;
        public static final /* enum */ ServingStatus STOPPED;
        public static final ServingStatus MIN_VALUE;
        public static final ServingStatus MAX_VALUE;
        private static final /* synthetic */ ServingStatus[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ServingStatus(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.netflix.spinnaker.clouddriver.appengine.model.AppengineServerGroup$ServingStatus was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public ServingStatus() {
            this(new LinkedHashMap());
        }

        public static final ServingStatus[] values() {
            return (ServingStatus[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), ServingStatus[].class);
        }

        public /* synthetic */ ServingStatus next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (ServingStatus)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ServingStatus.class);
        }

        public /* synthetic */ ServingStatus previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (ServingStatus)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ServingStatus.class);
        }

        public static ServingStatus valueOf(String name) {
            return (ServingStatus)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(ServingStatus.class, name)), ServingStatus.class);
        }

        public static final /* synthetic */ ServingStatus $INIT(Object ... para) {
            ServingStatus servingStatus;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, ServingStatus.class)) {
                case -1348271900: {
                    ServingStatus servingStatus2;
                    servingStatus = servingStatus2;
                    Object[] objectArray2 = objectArray;
                    servingStatus2 = new ServingStatus();
                    break;
                }
                case -242181752: {
                    ServingStatus servingStatus2;
                    servingStatus = servingStatus2;
                    Object[] objectArray2 = objectArray;
                    servingStatus2 = new ServingStatus((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return servingStatus;
        }

        static {
            ServingStatus servingStatus;
            ServingStatus servingStatus2;
            ServingStatus servingStatus3;
            ServingStatus servingStatus4;
            SERVING = servingStatus4 = ServingStatus.$INIT("SERVING", 0);
            STOPPED = servingStatus3 = ServingStatus.$INIT("STOPPED", 1);
            MIN_VALUE = servingStatus2 = SERVING;
            MAX_VALUE = servingStatus = STOPPED;
            ServingStatus[] servingStatusArray = new ServingStatus[]{SERVING, STOPPED};
            $VALUES = servingStatusArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ServingStatus.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static final class Environment
    extends Enum<Environment>
    implements GroovyObject {
        public static final /* enum */ Environment STANDARD;
        public static final /* enum */ Environment FLEXIBLE;
        public static final Environment MIN_VALUE;
        public static final Environment MAX_VALUE;
        private static final /* synthetic */ Environment[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Environment(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.netflix.spinnaker.clouddriver.appengine.model.AppengineServerGroup$Environment was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public Environment() {
            this(new LinkedHashMap());
        }

        public static final Environment[] values() {
            return (Environment[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Environment[].class);
        }

        public /* synthetic */ Environment next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Environment)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Environment.class);
        }

        public /* synthetic */ Environment previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Environment)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Environment.class);
        }

        public static Environment valueOf(String name) {
            return (Environment)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Environment.class, name)), Environment.class);
        }

        public static final /* synthetic */ Environment $INIT(Object ... para) {
            Environment environment;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Environment.class)) {
                case -1348271900: {
                    Environment environment2;
                    environment = environment2;
                    Object[] objectArray2 = objectArray;
                    environment2 = new Environment();
                    break;
                }
                case -242181752: {
                    Environment environment2;
                    environment = environment2;
                    Object[] objectArray2 = objectArray;
                    environment2 = new Environment((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return environment;
        }

        static {
            Environment environment;
            Environment environment2;
            Environment environment3;
            Environment environment4;
            STANDARD = environment4 = Environment.$INIT("STANDARD", 0);
            FLEXIBLE = environment3 = Environment.$INIT("FLEXIBLE", 1);
            MIN_VALUE = environment2 = STANDARD;
            MAX_VALUE = environment = FLEXIBLE;
            Environment[] environmentArray = new Environment[]{STANDARD, FLEXIBLE};
            $VALUES = environmentArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Environment.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

