/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.clouddriver.appengine.artifacts.GcsStorageService;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.config.StorageConfigurationProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"artifacts.gcs.enabled"})
@EnableConfigurationProperties(value={StorageConfigurationProperties.class})
@EnableScheduling
public class AppengineStorageConfiguration {
    @Autowired
    StorageConfigurationProperties storageAccountInfo;

    @Bean
    GcsStorageService.Factory storageServiceFactory(String clouddriverUserAgentApplicationName) {
        try {
            return new GcsStorageService.Factory(clouddriverUserAgentApplicationName);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

