/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.googlecommon.config.GoogleCommonManagedAccount;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerRetrofitErrorHandler;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.util.StringUtils;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;
import retrofit.http.GET;
import retrofit.http.Headers;
import retrofit.mime.TypedByteArray;

public class AppengineConfigurationProperties {
    private List<ManagedAccount> accounts = new ArrayList<ManagedAccount>();
    private String gcloudPath;

    @Generated
    public AppengineConfigurationProperties() {
    }

    @Generated
    public List<ManagedAccount> getAccounts() {
        return this.accounts;
    }

    @Generated
    public String getGcloudPath() {
        return this.gcloudPath;
    }

    @Generated
    public AppengineConfigurationProperties setAccounts(List<ManagedAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    @Generated
    public AppengineConfigurationProperties setGcloudPath(String gcloudPath) {
        this.gcloudPath = gcloudPath;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppengineConfigurationProperties)) {
            return false;
        }
        AppengineConfigurationProperties other = (AppengineConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ManagedAccount> this$accounts = this.getAccounts();
        List<ManagedAccount> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        String this$gcloudPath = this.getGcloudPath();
        String other$gcloudPath = other.getGcloudPath();
        return !(this$gcloudPath == null ? other$gcloudPath != null : !this$gcloudPath.equals(other$gcloudPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppengineConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ManagedAccount> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        String $gcloudPath = this.getGcloudPath();
        result = result * 59 + ($gcloudPath == null ? 43 : $gcloudPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AppengineConfigurationProperties(accounts=" + this.getAccounts() + ", gcloudPath=" + this.getGcloudPath() + ")";
    }

    public static class ManagedAccount
    extends GoogleCommonManagedAccount {
        public static final String metadataUrl = "http://metadata.google.internal/computeMetadata/v1";
        private String serviceAccountEmail;
        private String computedServiceAccountEmail;
        private String localRepositoryDirectory = "/var/tmp/clouddriver";
        private String gitHttpsUsername;
        private String gitHttpsPassword;
        private String githubOAuthAccessToken;
        private String sshPrivateKeyFilePath;
        private String sshPrivateKeyPassphrase;
        private String sshKnownHostsFilePath;
        private boolean sshTrustUnknownHosts;
        private GcloudReleaseTrack gcloudReleaseTrack;
        private List<String> services;
        private List<String> versions;
        private List<String> omitServices;
        private List<String> omitVersions;
        private Long cachingIntervalSeconds;

        public void initialize(AppengineJobExecutor jobExecutor, String gcloudPath) {
            if (!StringUtils.isEmpty((Object)this.getJsonPath())) {
                jobExecutor.runCommand(List.of(gcloudPath, "auth", "activate-service-account", "--key-file", this.getJsonPath()));
                ObjectMapper mapper = new ObjectMapper();
                try {
                    JsonNode node = mapper.readTree(new File(this.getJsonPath()));
                    if (StringUtils.isEmpty((Object)this.getProject())) {
                        this.setProject(node.get("project_id").asText());
                    }
                    if (StringUtils.isEmpty((Object)this.serviceAccountEmail)) {
                        this.computedServiceAccountEmail = node.get("client_email").asText();
                    }
                    this.computedServiceAccountEmail = this.serviceAccountEmail;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not find read JSON configuration file.", e);
                }
            } else {
                MetadataService metadataService = ManagedAccount.createMetadataService();
                try {
                    if (StringUtils.isEmpty((Object)this.getProject())) {
                        this.setProject(ManagedAccount.responseToString(metadataService.getProject()));
                    }
                    this.computedServiceAccountEmail = ManagedAccount.responseToString(metadataService.getApplicationDefaultServiceAccountEmail());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not find application default credentials for App Engine.", e);
                }
            }
        }

        static MetadataService createMetadataService() {
            OkHttpClient client = new OkHttpClient();
            client.setRetryOnConnectionFailure(true);
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(metadataUrl).setConverter((Converter)new JacksonConverter()).setClient((Client)new OkClient(client)).setErrorHandler((ErrorHandler)SpinnakerRetrofitErrorHandler.getInstance()).build();
            return (MetadataService)restAdapter.create(MetadataService.class);
        }

        static String responseToString(Response response) {
            return new String(((TypedByteArray)response.getBody()).getBytes());
        }

        @Generated
        public ManagedAccount() {
        }

        @Generated
        public String getServiceAccountEmail() {
            return this.serviceAccountEmail;
        }

        @Generated
        public String getComputedServiceAccountEmail() {
            return this.computedServiceAccountEmail;
        }

        @Generated
        public String getLocalRepositoryDirectory() {
            return this.localRepositoryDirectory;
        }

        @Generated
        public String getGitHttpsUsername() {
            return this.gitHttpsUsername;
        }

        @Generated
        public String getGitHttpsPassword() {
            return this.gitHttpsPassword;
        }

        @Generated
        public String getGithubOAuthAccessToken() {
            return this.githubOAuthAccessToken;
        }

        @Generated
        public String getSshPrivateKeyFilePath() {
            return this.sshPrivateKeyFilePath;
        }

        @Generated
        public String getSshPrivateKeyPassphrase() {
            return this.sshPrivateKeyPassphrase;
        }

        @Generated
        public String getSshKnownHostsFilePath() {
            return this.sshKnownHostsFilePath;
        }

        @Generated
        public boolean isSshTrustUnknownHosts() {
            return this.sshTrustUnknownHosts;
        }

        @Generated
        public GcloudReleaseTrack getGcloudReleaseTrack() {
            return this.gcloudReleaseTrack;
        }

        @Generated
        public List<String> getServices() {
            return this.services;
        }

        @Generated
        public List<String> getVersions() {
            return this.versions;
        }

        @Generated
        public List<String> getOmitServices() {
            return this.omitServices;
        }

        @Generated
        public List<String> getOmitVersions() {
            return this.omitVersions;
        }

        @Generated
        public Long getCachingIntervalSeconds() {
            return this.cachingIntervalSeconds;
        }

        @Generated
        public ManagedAccount setServiceAccountEmail(String serviceAccountEmail) {
            this.serviceAccountEmail = serviceAccountEmail;
            return this;
        }

        @Generated
        public ManagedAccount setComputedServiceAccountEmail(String computedServiceAccountEmail) {
            this.computedServiceAccountEmail = computedServiceAccountEmail;
            return this;
        }

        @Generated
        public ManagedAccount setLocalRepositoryDirectory(String localRepositoryDirectory) {
            this.localRepositoryDirectory = localRepositoryDirectory;
            return this;
        }

        @Generated
        public ManagedAccount setGitHttpsUsername(String gitHttpsUsername) {
            this.gitHttpsUsername = gitHttpsUsername;
            return this;
        }

        @Generated
        public ManagedAccount setGitHttpsPassword(String gitHttpsPassword) {
            this.gitHttpsPassword = gitHttpsPassword;
            return this;
        }

        @Generated
        public ManagedAccount setGithubOAuthAccessToken(String githubOAuthAccessToken) {
            this.githubOAuthAccessToken = githubOAuthAccessToken;
            return this;
        }

        @Generated
        public ManagedAccount setSshPrivateKeyFilePath(String sshPrivateKeyFilePath) {
            this.sshPrivateKeyFilePath = sshPrivateKeyFilePath;
            return this;
        }

        @Generated
        public ManagedAccount setSshPrivateKeyPassphrase(String sshPrivateKeyPassphrase) {
            this.sshPrivateKeyPassphrase = sshPrivateKeyPassphrase;
            return this;
        }

        @Generated
        public ManagedAccount setSshKnownHostsFilePath(String sshKnownHostsFilePath) {
            this.sshKnownHostsFilePath = sshKnownHostsFilePath;
            return this;
        }

        @Generated
        public ManagedAccount setSshTrustUnknownHosts(boolean sshTrustUnknownHosts) {
            this.sshTrustUnknownHosts = sshTrustUnknownHosts;
            return this;
        }

        @Generated
        public ManagedAccount setGcloudReleaseTrack(GcloudReleaseTrack gcloudReleaseTrack) {
            this.gcloudReleaseTrack = gcloudReleaseTrack;
            return this;
        }

        @Generated
        public ManagedAccount setServices(List<String> services) {
            this.services = services;
            return this;
        }

        @Generated
        public ManagedAccount setVersions(List<String> versions) {
            this.versions = versions;
            return this;
        }

        @Generated
        public ManagedAccount setOmitServices(List<String> omitServices) {
            this.omitServices = omitServices;
            return this;
        }

        @Generated
        public ManagedAccount setOmitVersions(List<String> omitVersions) {
            this.omitVersions = omitVersions;
            return this;
        }

        @Generated
        public ManagedAccount setCachingIntervalSeconds(Long cachingIntervalSeconds) {
            this.cachingIntervalSeconds = cachingIntervalSeconds;
            return this;
        }

        @Generated
        public String toString() {
            return "AppengineConfigurationProperties.ManagedAccount(serviceAccountEmail=" + this.getServiceAccountEmail() + ", computedServiceAccountEmail=" + this.getComputedServiceAccountEmail() + ", localRepositoryDirectory=" + this.getLocalRepositoryDirectory() + ", gitHttpsUsername=" + this.getGitHttpsUsername() + ", gitHttpsPassword=" + this.getGitHttpsPassword() + ", githubOAuthAccessToken=" + this.getGithubOAuthAccessToken() + ", sshPrivateKeyFilePath=" + this.getSshPrivateKeyFilePath() + ", sshPrivateKeyPassphrase=" + this.getSshPrivateKeyPassphrase() + ", sshKnownHostsFilePath=" + this.getSshKnownHostsFilePath() + ", sshTrustUnknownHosts=" + this.isSshTrustUnknownHosts() + ", gcloudReleaseTrack=" + this.getGcloudReleaseTrack() + ", services=" + this.getServices() + ", versions=" + this.getVersions() + ", omitServices=" + this.getOmitServices() + ", omitVersions=" + this.getOmitVersions() + ", cachingIntervalSeconds=" + this.getCachingIntervalSeconds() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagedAccount)) {
                return false;
            }
            ManagedAccount other = (ManagedAccount)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isSshTrustUnknownHosts() != other.isSshTrustUnknownHosts()) {
                return false;
            }
            Long this$cachingIntervalSeconds = this.getCachingIntervalSeconds();
            Long other$cachingIntervalSeconds = other.getCachingIntervalSeconds();
            if (this$cachingIntervalSeconds == null ? other$cachingIntervalSeconds != null : !((Object)this$cachingIntervalSeconds).equals(other$cachingIntervalSeconds)) {
                return false;
            }
            String this$serviceAccountEmail = this.getServiceAccountEmail();
            String other$serviceAccountEmail = other.getServiceAccountEmail();
            if (this$serviceAccountEmail == null ? other$serviceAccountEmail != null : !this$serviceAccountEmail.equals(other$serviceAccountEmail)) {
                return false;
            }
            String this$localRepositoryDirectory = this.getLocalRepositoryDirectory();
            String other$localRepositoryDirectory = other.getLocalRepositoryDirectory();
            if (this$localRepositoryDirectory == null ? other$localRepositoryDirectory != null : !this$localRepositoryDirectory.equals(other$localRepositoryDirectory)) {
                return false;
            }
            String this$gitHttpsUsername = this.getGitHttpsUsername();
            String other$gitHttpsUsername = other.getGitHttpsUsername();
            if (this$gitHttpsUsername == null ? other$gitHttpsUsername != null : !this$gitHttpsUsername.equals(other$gitHttpsUsername)) {
                return false;
            }
            String this$gitHttpsPassword = this.getGitHttpsPassword();
            String other$gitHttpsPassword = other.getGitHttpsPassword();
            if (this$gitHttpsPassword == null ? other$gitHttpsPassword != null : !this$gitHttpsPassword.equals(other$gitHttpsPassword)) {
                return false;
            }
            String this$githubOAuthAccessToken = this.getGithubOAuthAccessToken();
            String other$githubOAuthAccessToken = other.getGithubOAuthAccessToken();
            if (this$githubOAuthAccessToken == null ? other$githubOAuthAccessToken != null : !this$githubOAuthAccessToken.equals(other$githubOAuthAccessToken)) {
                return false;
            }
            String this$sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
            String other$sshPrivateKeyFilePath = other.getSshPrivateKeyFilePath();
            if (this$sshPrivateKeyFilePath == null ? other$sshPrivateKeyFilePath != null : !this$sshPrivateKeyFilePath.equals(other$sshPrivateKeyFilePath)) {
                return false;
            }
            String this$sshPrivateKeyPassphrase = this.getSshPrivateKeyPassphrase();
            String other$sshPrivateKeyPassphrase = other.getSshPrivateKeyPassphrase();
            if (this$sshPrivateKeyPassphrase == null ? other$sshPrivateKeyPassphrase != null : !this$sshPrivateKeyPassphrase.equals(other$sshPrivateKeyPassphrase)) {
                return false;
            }
            String this$sshKnownHostsFilePath = this.getSshKnownHostsFilePath();
            String other$sshKnownHostsFilePath = other.getSshKnownHostsFilePath();
            if (this$sshKnownHostsFilePath == null ? other$sshKnownHostsFilePath != null : !this$sshKnownHostsFilePath.equals(other$sshKnownHostsFilePath)) {
                return false;
            }
            GcloudReleaseTrack this$gcloudReleaseTrack = this.getGcloudReleaseTrack();
            GcloudReleaseTrack other$gcloudReleaseTrack = other.getGcloudReleaseTrack();
            if (this$gcloudReleaseTrack == null ? other$gcloudReleaseTrack != null : !((Object)((Object)this$gcloudReleaseTrack)).equals((Object)other$gcloudReleaseTrack)) {
                return false;
            }
            List<String> this$services = this.getServices();
            List<String> other$services = other.getServices();
            if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
                return false;
            }
            List<String> this$versions = this.getVersions();
            List<String> other$versions = other.getVersions();
            if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
                return false;
            }
            List<String> this$omitServices = this.getOmitServices();
            List<String> other$omitServices = other.getOmitServices();
            if (this$omitServices == null ? other$omitServices != null : !((Object)this$omitServices).equals(other$omitServices)) {
                return false;
            }
            List<String> this$omitVersions = this.getOmitVersions();
            List<String> other$omitVersions = other.getOmitVersions();
            return !(this$omitVersions == null ? other$omitVersions != null : !((Object)this$omitVersions).equals(other$omitVersions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ManagedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isSshTrustUnknownHosts() ? 79 : 97);
            Long $cachingIntervalSeconds = this.getCachingIntervalSeconds();
            result = result * 59 + ($cachingIntervalSeconds == null ? 43 : ((Object)$cachingIntervalSeconds).hashCode());
            String $serviceAccountEmail = this.getServiceAccountEmail();
            result = result * 59 + ($serviceAccountEmail == null ? 43 : $serviceAccountEmail.hashCode());
            String $localRepositoryDirectory = this.getLocalRepositoryDirectory();
            result = result * 59 + ($localRepositoryDirectory == null ? 43 : $localRepositoryDirectory.hashCode());
            String $gitHttpsUsername = this.getGitHttpsUsername();
            result = result * 59 + ($gitHttpsUsername == null ? 43 : $gitHttpsUsername.hashCode());
            String $gitHttpsPassword = this.getGitHttpsPassword();
            result = result * 59 + ($gitHttpsPassword == null ? 43 : $gitHttpsPassword.hashCode());
            String $githubOAuthAccessToken = this.getGithubOAuthAccessToken();
            result = result * 59 + ($githubOAuthAccessToken == null ? 43 : $githubOAuthAccessToken.hashCode());
            String $sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
            result = result * 59 + ($sshPrivateKeyFilePath == null ? 43 : $sshPrivateKeyFilePath.hashCode());
            String $sshPrivateKeyPassphrase = this.getSshPrivateKeyPassphrase();
            result = result * 59 + ($sshPrivateKeyPassphrase == null ? 43 : $sshPrivateKeyPassphrase.hashCode());
            String $sshKnownHostsFilePath = this.getSshKnownHostsFilePath();
            result = result * 59 + ($sshKnownHostsFilePath == null ? 43 : $sshKnownHostsFilePath.hashCode());
            GcloudReleaseTrack $gcloudReleaseTrack = this.getGcloudReleaseTrack();
            result = result * 59 + ($gcloudReleaseTrack == null ? 43 : ((Object)((Object)$gcloudReleaseTrack)).hashCode());
            List<String> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            List<String> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            List<String> $omitServices = this.getOmitServices();
            result = result * 59 + ($omitServices == null ? 43 : ((Object)$omitServices).hashCode());
            List<String> $omitVersions = this.getOmitVersions();
            result = result * 59 + ($omitVersions == null ? 43 : ((Object)$omitVersions).hashCode());
            return result;
        }

        public static enum GcloudReleaseTrack {
            ALPHA,
            BETA,
            STABLE;

        }

        static interface MetadataService {
            @Headers(value={"Metadata-Flavor: Google"})
            @GET(value="/project/project-id")
            public Response getProject();

            @Headers(value={"Metadata-Flavor: Google"})
            @GET(value="/instance/service-accounts/default/email")
            public Response getApplicationDefaultServiceAccountEmail();
        }
    }
}

