/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.gcsClient;

import com.google.api.services.storage.model.StorageObject;
import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.ArtifactUtils;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.GcsStorageService;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineRepositoryClient;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppengineGcsRepositoryClient
implements AppengineRepositoryClient,
GroovyObject {
    private String repositoryUrl;
    private String targetDirectoryPath;
    private String applicationDirectoryRoot;
    private GcsStorageService storage;
    private AppengineJobExecutor jobExecutor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AppengineGcsRepositoryClient(String repositoryUrl, String targetDirectoryPath, String applicationDirectoryRoot, GcsStorageService storage, AppengineJobExecutor jobExecutor) {
        AppengineJobExecutor appengineJobExecutor;
        GcsStorageService gcsStorageService;
        String string;
        String string2;
        String string3;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.repositoryUrl = string3 = repositoryUrl;
        this.targetDirectoryPath = string2 = targetDirectoryPath;
        this.applicationDirectoryRoot = string = applicationDirectoryRoot;
        this.storage = gcsStorageService = storage;
        this.jobExecutor = appengineJobExecutor = jobExecutor;
    }

    @Generated
    public AppengineGcsRepositoryClient(String repositoryUrl, String targetDirectoryPath, String applicationDirectoryRoot, GcsStorageService storage) {
        CallSite[] callSiteArray = AppengineGcsRepositoryClient.$getCallSiteArray();
        this(repositoryUrl, targetDirectoryPath, applicationDirectoryRoot, storage, null);
    }

    @Generated
    public AppengineGcsRepositoryClient(String repositoryUrl, String targetDirectoryPath, String applicationDirectoryRoot) {
        CallSite[] callSiteArray = AppengineGcsRepositoryClient.$getCallSiteArray();
        this(repositoryUrl, targetDirectoryPath, applicationDirectoryRoot, null, null);
    }

    @Generated
    public AppengineGcsRepositoryClient(String repositoryUrl, String targetDirectoryPath) {
        CallSite[] callSiteArray = AppengineGcsRepositoryClient.$getCallSiteArray();
        this(repositoryUrl, targetDirectoryPath, null, null, null);
    }

    @Generated
    public AppengineGcsRepositoryClient(String repositoryUrl) {
        CallSite[] callSiteArray = AppengineGcsRepositoryClient.$getCallSiteArray();
        this(repositoryUrl, null, null, null, null);
    }

    @Generated
    public AppengineGcsRepositoryClient() {
        CallSite[] callSiteArray = AppengineGcsRepositoryClient.$getCallSiteArray();
        this(null, null, null, null, null);
    }

    @Override
    public void initializeLocalDirectory() {
        this.downloadFiles();
    }

    @Override
    public void updateLocalDirectoryWithVersion(String version) {
        this.downloadFiles();
    }

    public void downloadFiles() {
        String gsPrefix = "gs://";
        if (!this.repositoryUrl.startsWith(gsPrefix)) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Repository is not a GCS bucket: ", (CharSequence)this.repositoryUrl));
        }
        Reference dest = new Reference((Object)(DefaultTypeTransformation.booleanUnbox((Object)this.applicationDirectoryRoot) ? StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.targetDirectoryPath, (CharSequence)File.separator), (CharSequence)this.applicationDirectoryRoot) : this.targetDirectoryPath));
        String fullPath = this.repositoryUrl.substring(gsPrefix.length());
        if (DefaultTypeTransformation.booleanUnbox((Object)this.applicationDirectoryRoot)) {
            fullPath = StringGroovyMethods.plus((String)fullPath, (CharSequence)new GStringImpl(new Object[]{this.applicationDirectoryRoot}, new String[]{"/", ""}));
        }
        int slash = fullPath.indexOf("/");
        String bucketName = fullPath.substring(0, slash);
        String bucketPath = fullPath.substring(slash + 1);
        Long version = null;
        int versionSeparator = bucketPath.indexOf("#");
        if (versionSeparator >= 0) {
            String versionString = bucketPath.substring(versionSeparator + 1);
            if (!versionString.isEmpty()) {
                version = Long.parseLong(versionString);
            }
            bucketPath = bucketPath.substring(0, versionSeparator);
        }
        File targetDirectory = new File(this.targetDirectoryPath);
        if (targetDirectory.exists() && targetDirectory.isDirectory()) {
            FileUtils.forceDelete((File)targetDirectory);
        } else if (targetDirectory.exists() && targetDirectory.isFile()) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{null}, new String[]{"GAE staging directory resolved to a file: ", ", failing..."})));
                v0 = null;
            } else {
                v0 = null;
            }
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{null}, new String[]{"GAE staging directory resolved to a file: ", ", failing..."})));
        }
        if (bucketPath.endsWith(".tar")) {
            InputStream tas = this.storage.openObjectStream(bucketName, bucketPath, version);
            File tempFile = File.createTempFile("app", "tar");
            FileOutputStream fos = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)tas, (OutputStream)fos);
            tas.close();
            fos.close();
            ArtifactUtils.untarStreamToPath(new FileInputStream(tempFile), (String)dest.get());
            tempFile.delete();
        } else {
            public final class _downloadFiles_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference dest;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _downloadFiles_closure1(Object _outerInstance, Object _thisObject, Reference dest) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.dest = reference = dest;
                }

                public Void doCall(Object obj) {
                    ((AppengineGcsRepositoryClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AppengineGcsRepositoryClient.class)).getStorage().downloadStorageObject((StorageObject)ScriptBytecodeAdapter.castToType((Object)obj, StorageObject.class), ShortTypeHandling.castToString((Object)this.dest.get()));
                    return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                }

                @Generated
                public Object getDest() {
                    return this.dest.get();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _downloadFiles_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.storage.visitObjects(bucketName, bucketPath, (GcsStorageService.VisitorOperation)ScriptBytecodeAdapter.castToType((Object)((Object)new _downloadFiles_closure1(this, this, dest)), GcsStorageService.VisitorOperation.class));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AppengineGcsRepositoryClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ GcsStorageService pfaccess$0(AppengineGcsRepositoryClient $that) {
        return $that.storage;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.appengine.gcsClient.AppengineGcsRepositoryClient");
    }

    @Generated
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Generated
    public void setRepositoryUrl(String string) {
        this.repositoryUrl = string;
    }

    @Generated
    public String getTargetDirectoryPath() {
        return this.targetDirectoryPath;
    }

    @Generated
    public void setTargetDirectoryPath(String string) {
        this.targetDirectoryPath = string;
    }

    @Generated
    public String getApplicationDirectoryRoot() {
        return this.applicationDirectoryRoot;
    }

    @Generated
    public void setApplicationDirectoryRoot(String string) {
        this.applicationDirectoryRoot = string;
    }

    @Generated
    public GcsStorageService getStorage() {
        return this.storage;
    }

    @Generated
    public void setStorage(GcsStorageService gcsStorageService) {
        this.storage = gcsStorageService;
    }

    @Generated
    public AppengineJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Generated
    public void setJobExecutor(AppengineJobExecutor appengineJobExecutor) {
        this.jobExecutor = appengineJobExecutor;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AppengineGcsRepositoryClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AppengineGcsRepositoryClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

