/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.artifacts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ArtifactUtils {
    public static void untarStreamToPath(InputStream inputStream, String basePath) throws IOException {
        class DirectoryTimestamp {
            public File directory;
            public long millis;

            public DirectoryTimestamp(File d, long m) {
                this.directory = d;
                this.millis = m;
            }
        }
        Stack<DirectoryTimestamp> directoryStack = new Stack<DirectoryTimestamp>();
        File baseDirectory = new File(basePath);
        baseDirectory.mkdir();
        TarArchiveInputStream tarStream = new TarArchiveInputStream(inputStream);
        TarArchiveEntry entry = tarStream.getNextTarEntry();
        while (entry != null) {
            String canonicalBaseDirPath;
            File target = new File(baseDirectory, entry.getName());
            String canonicalTargetPath = target.getCanonicalPath();
            if (!canonicalTargetPath.startsWith(canonicalBaseDirPath = baseDirectory.getCanonicalPath())) {
                throw new RuntimeException("Entry is outside of the target directory (" + entry.getName() + ")");
            }
            if (entry.isDirectory()) {
                directoryStack.push(new DirectoryTimestamp(target, entry.getModTime().getTime()));
            } else {
                ArtifactUtils.writeStreamToFile((InputStream)tarStream, target);
                target.setLastModified(entry.getModTime().getTime());
            }
            entry = tarStream.getNextTarEntry();
        }
        while (!directoryStack.empty()) {
            DirectoryTimestamp info = (DirectoryTimestamp)directoryStack.pop();
            info.directory.setLastModified(info.millis);
        }
        tarStream.close();
    }

    public static void writeStreamToFile(InputStream sourceStream, File target) throws IOException {
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream targetStream = new FileOutputStream(target);
        IOUtils.copy((InputStream)sourceStream, (OutputStream)targetStream);
        ((OutputStream)targetStream).close();
    }
}

