/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.artifacts;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.ArtifactUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsStorageService {
    private static final Logger log = LoggerFactory.getLogger(GcsStorageService.class);
    private Storage storage_;

    public GcsStorageService(Storage storage) {
        this.storage_ = storage;
    }

    public InputStream openObjectStream(String bucketName, String path, Long generation) throws IOException {
        Storage.Objects.Get get = this.storage_.objects().get(bucketName, path);
        if (generation != null) {
            get.setGeneration(generation);
        }
        return get.executeMediaAsInputStream();
    }

    public void visitObjects(String bucketName, String pathPrefix, VisitorOperation op) throws IOException {
        Objects objects;
        Storage.Objects.List listMethod = this.storage_.objects().list(bucketName);
        listMethod.setPrefix(pathPrefix);
        ExecutorService executor = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat(GcsStorageService.class.getSimpleName() + "-%d").build());
        do {
            List items;
            if ((items = (objects = (Objects)listMethod.execute()).getItems()) != null) {
                for (StorageObject obj : items) {
                    executor.submit(() -> {
                        try {
                            op.visit(obj);
                        }
                        catch (IOException ioex) {
                            throw new IllegalStateException(ioex);
                        }
                    });
                }
            }
            listMethod.setPageToken(objects.getNextPageToken());
        } while (objects.getNextPageToken() != null);
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.MINUTES)) {
                throw new IllegalStateException("Timed out waiting to process StorageObjects.");
            }
        }
        catch (InterruptedException intex) {
            throw new IllegalStateException(intex);
        }
    }

    public void visitObjects(String bucketName, VisitorOperation op) throws IOException {
        this.visitObjects(bucketName, "", op);
    }

    public void downloadStorageObjectRelative(StorageObject obj, String ignorePrefix, String baseDirectory) throws IOException {
        String objPath = obj.getName();
        if (!((String)ignorePrefix).isEmpty()) {
            if (!objPath.startsWith((String)(ignorePrefix = (String)ignorePrefix + File.separator))) {
                throw new IllegalArgumentException(objPath + " does not start with '" + (String)ignorePrefix + "'");
            }
            objPath = objPath.substring(((String)ignorePrefix).length());
        }
        if (objPath.endsWith("/")) {
            return;
        }
        File target = new File(baseDirectory, objPath);
        try (InputStream stream = this.openObjectStream(obj.getBucket(), obj.getName(), obj.getGeneration());){
            ArtifactUtils.writeStreamToFile(stream, target);
        }
        target.setLastModified(obj.getUpdated().getValue());
    }

    public void downloadStorageObject(StorageObject obj, String baseDirectory) throws IOException {
        this.downloadStorageObjectRelative(obj, "", baseDirectory);
    }

    public static interface VisitorOperation {
        public void visit(StorageObject var1) throws IOException;
    }

    public static class Factory {
        private String applicationName_;
        private HttpTransport transport_;
        private JsonFactory jsonFactory_;

        public Factory(String applicationName) throws IOException, GeneralSecurityException {
            this.applicationName_ = applicationName;
            this.transport_ = GoogleNetHttpTransport.newTrustedTransport();
            this.jsonFactory_ = GsonFactory.getDefaultInstance();
        }

        public Factory(String applicationName, HttpTransport transport, JsonFactory jsonFactory) {
            this.applicationName_ = applicationName;
            this.transport_ = transport;
            this.jsonFactory_ = jsonFactory;
        }

        public GcsStorageService newForCredentials(String credentialsPath) throws IOException {
            GoogleCredentials credentials = this.loadCredentials(credentialsPath);
            HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)credentials);
            Storage storage = new Storage.Builder(this.transport_, this.jsonFactory_, (HttpRequestInitializer)requestInitializer).setApplicationName(this.applicationName_).build();
            return new GcsStorageService(storage);
        }

        private GoogleCredentials loadCredentials(String credentialsPath) throws IOException {
            GoogleCredentials credentials;
            if (credentialsPath != null && !credentialsPath.isEmpty()) {
                FileInputStream stream = new FileInputStream(credentialsPath);
                credentials = GoogleCredentials.fromStream((InputStream)stream).createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.read_only"));
                log.info("Loaded credentials from " + credentialsPath);
            } else {
                log.info("spinnaker.gcs.enabled without spinnaker.gcs.jsonPath. Using default application credentials. Using default credentials.");
                credentials = GoogleCredentials.getApplicationDefault();
            }
            return credentials;
        }
    }
}

