/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.artifacts.config;

import groovy.transform.ToString;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;

@ConfigurationProperties(value="artifacts.gcs")
public class StorageConfigurationProperties {
    List<ManagedAccount> accounts = new ArrayList<ManagedAccount>();

    ManagedAccount getAccount(String name) {
        for (ManagedAccount account : this.accounts) {
            if (!account.getName().equals(name)) continue;
            return account;
        }
        throw new NoSuchElementException("Unknown storage account: " + name);
    }

    @Generated
    public StorageConfigurationProperties() {
    }

    @Generated
    public List<ManagedAccount> getAccounts() {
        return this.accounts;
    }

    @Generated
    public StorageConfigurationProperties setAccounts(List<ManagedAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageConfigurationProperties)) {
            return false;
        }
        StorageConfigurationProperties other = (StorageConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ManagedAccount> this$accounts = this.getAccounts();
        List<ManagedAccount> other$accounts = other.getAccounts();
        return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StorageConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ManagedAccount> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StorageConfigurationProperties(accounts=" + this.getAccounts() + ")";
    }

    @ToString(includeNames=true)
    public static class ManagedAccount {
        String name;
        String jsonPath;

        public static String responseToString(Response response) {
            return new String(((TypedByteArray)response.getBody()).getBytes());
        }

        @Generated
        public ManagedAccount() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getJsonPath() {
            return this.jsonPath;
        }

        @Generated
        public ManagedAccount setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ManagedAccount setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagedAccount)) {
                return false;
            }
            ManagedAccount other = (ManagedAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$jsonPath = this.getJsonPath();
            String other$jsonPath = other.getJsonPath();
            return !(this$jsonPath == null ? other$jsonPath != null : !this$jsonPath.equals(other$jsonPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ManagedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $jsonPath = this.getJsonPath();
            result = result * 59 + ($jsonPath == null ? 43 : $jsonPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StorageConfigurationProperties.ManagedAccount(name=" + this.getName() + ", jsonPath=" + this.getJsonPath() + ")";
        }
    }
}

