/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy;

import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.appengine.deploy.exception.AppengineOperationException;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleApiException;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleCommonSafeRetry;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import groovy.lang.Closure;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public final class AppengineSafeRetry {
    private final GoogleCommonSafeRetry googleCommonSafeRetry;

    @Autowired
    @ParametersAreNullableByDefault
    public AppengineSafeRetry(@Value(value="${appengine.safe-retry-max-wait-interval-ms:60000}") Integer maxWaitInterval, @Value(value="${appengine.safe-retry-retry-interval-base-sec:2}") Integer retryIntervalBase, @Value(value="${appengine.safe-retry-jitter-multiplier:1000}") Integer jitterMultiplier, @Value(value="${appengine.safe-retry-max-retries:10}") Integer maxRetries) {
        this.googleCommonSafeRetry = new GoogleCommonSafeRetry(maxWaitInterval, retryIntervalBase, jitterMultiplier, maxRetries);
    }

    private AppengineSafeRetry(GoogleCommonSafeRetry googleCommonSafeRetry) {
        this.googleCommonSafeRetry = googleCommonSafeRetry;
    }

    public static AppengineSafeRetry withoutDelay() {
        return new AppengineSafeRetry(GoogleCommonSafeRetry.withoutDelay());
    }

    @Nullable
    public <V> V doRetry(Closure<V> operation, String resource, @Nullable Task task, List<Integer> retryCodes, Map<String, String> tags, Registry registry) {
        String action = tags.get("action");
        String description = String.format("%s of %s", action, resource);
        if (task != null) {
            task.updateStatus(tags.get("phase"), String.format("Attempting %s...", description));
        }
        try {
            return (V)this.googleCommonSafeRetry.doRetry(operation, description, retryCodes, (List)ImmutableList.of(), tags, registry);
        }
        catch (GoogleApiException e) {
            throw new AppengineOperationException("Failed to " + description, e);
        }
    }
}

