/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy.validators;

import com.netflix.spinnaker.clouddriver.appengine.gitClient.AppengineGitCredentialType;
import com.netflix.spinnaker.clouddriver.appengine.gitClient.AppengineGitCredentials;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineInstance;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineModelUtil;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineServerGroup;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineTrafficSplit;
import com.netflix.spinnaker.clouddriver.appengine.model.ScalingPolicyType;
import com.netflix.spinnaker.clouddriver.appengine.model.ShardBy;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineClusterProvider;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineInstanceProvider;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.appengine.security.AppengineNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class StandardAppengineAttributeValidator
implements GroovyObject {
    private static final Object namePattern;
    private static final Object prefixPattern;
    private String context;
    private ValidationErrors errors;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public StandardAppengineAttributeValidator(String context, ValidationErrors errors) {
        ValidationErrors validationErrors;
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.context = string = context;
        this.errors = validationErrors = errors;
    }

    public Object validateCredentials(String credentials, CredentialsRepository<AppengineNamedAccountCredentials> credentialsRepository) {
        Object result = IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, credentials, "account");
        if (IndyInterface.bootstrap("cast", "()", 0, result) != false) {
            CallSite appengineCredentials = IndyInterface.bootstrap("invoke", "getOne", 0, credentialsRepository, credentials);
            if (IndyInterface.bootstrap("cast", "()", 0, appengineCredentials) == false) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context}, new String[]{"", ".account"}), new GStringImpl(new Object[]{this.context}, new String[]{"", ".account.notFound"}));
                result = false;
            }
        }
        return result;
    }

    public Object validateGitCredentials(AppengineGitCredentials gitCredentials, AppengineGitCredentialType gitCredentialType, String accountName, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, gitCredentialType, attribute)) != false) {
            CallSite supportedCredentialTypes = IndyInterface.bootstrap("invoke", "getSupportedCredentialTypes", 0, gitCredentials);
            CallSite credentialTypeSupported = IndyInterface.bootstrap("invoke", "contains", 0, supportedCredentialTypes, gitCredentialType);
            if (IndyInterface.bootstrap("cast", "()", 0, credentialTypeSupported) != false) {
                return true;
            }
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid"}), new GStringImpl(new Object[]{accountName, IndyInterface.bootstrap("invoke", "join", 0, supportedCredentialTypes, ", ")}, new String[]{" (Account ", " supports only the following git credential types: ", ""})));
            return false;
        }
        return false;
    }

    public Object validateNotEmpty(Object value, String attribute) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
            return true;
        }
        IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
        return false;
    }

    public Object validateApplication(String value, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, value, attribute)) != false) {
            return IndyInterface.bootstrap("invoke", "validateByRegex", 2, this, value, attribute, prefixPattern);
        }
        return false;
    }

    public Object validateStack(String value, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, value) == false) {
            return true;
        }
        return IndyInterface.bootstrap("invoke", "validateByRegex", 2, this, value, attribute, prefixPattern);
    }

    public Object validateDetails(String value, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, value) == false) {
            return true;
        }
        return IndyInterface.bootstrap("invoke", "validateByRegex", 2, this, value, attribute, namePattern);
    }

    public Object validateByRegex(String value, String attribute, String regex) {
        if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)regex)) {
            return true;
        }
        IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute, regex}, new String[]{"", ".", ".invalid (Must match ", ")"}));
        return false;
    }

    public Object validateTrafficSplit(AppengineTrafficSplit trafficSplit, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, trafficSplit, attribute)) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "allocations", 4, trafficSplit)) != false) {
                return IndyInterface.bootstrap("invoke", "validateAllocations", 2, this, IndyInterface.bootstrap("getProperty", "allocations", 4, trafficSplit), IndyInterface.bootstrap("getProperty", "shardBy", 4, trafficSplit), IndyInterface.bootstrap("invoke", "plus", 0, attribute, ".allocations"));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "shardBy", 4, trafficSplit)) != false) {
                return true;
            }
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return false;
    }

    public Object validateMaxNotLessThanMin(Integer minValue, Integer maxValue, String minAttribute, String maxAttribute) {
        if (ScriptBytecodeAdapter.compareLessThan((Object)maxValue, (Object)minValue)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, maxAttribute, new GStringImpl(new Object[]{this.context, maxAttribute, this.context, minAttribute}, new String[]{"", ".", " must not be less than ", ".", "."}));
            return false;
        }
        return true;
    }

    public Object validateNonNegative(Integer value, String attribute) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && ScriptBytecodeAdapter.compareLessThan((Object)value, (Object)0)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            return false;
        }
        return true;
    }

    public Object validateAllocations(Map<String, Double> allocations, ShardBy shardBy, String attribute) {
        Reference decimalPlaces = new Reference((Object)(ScriptBytecodeAdapter.compareEqual((Object)((Object)shardBy), (Object)IndyInterface.bootstrap("getProperty", "COOKIE", 0, ShardBy.class)) ? IndyInterface.bootstrap("getProperty", "COOKIE_SPLIT_DECIMAL_PLACES", 0, AppengineModelUtil.class) : IndyInterface.bootstrap("getProperty", "IP_SPLIT_DECIMAL_PLACES", 0, AppengineModelUtil.class)));
        Reference serverGroupsWithInvalidAllocations = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _validateAllocations_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference decimalPlaces;
            private /* synthetic */ Reference serverGroupsWithInvalidAllocations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateAllocations_closure1(Object _outerInstance, Object _thisObject, Reference decimalPlaces, Reference serverGroupsWithInvalidAllocations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.decimalPlaces = reference2 = decimalPlaces;
                this.serverGroupsWithInvalidAllocations = reference = serverGroupsWithInvalidAllocations;
            }

            public Object doCall(Object serverGroupName, Object allocation) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "round", 0, (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, allocation, Double.class)), this.decimalPlaces.get()), (Object)allocation)) {
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, this.serverGroupsWithInvalidAllocations.get(), serverGroupName);
                }
                return null;
            }

            @Generated
            public Object call(Object serverGroupName, Object allocation) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroupName, allocation);
            }

            @Generated
            public Object getDecimalPlaces() {
                return this.decimalPlaces.get();
            }

            @Generated
            public Object getServerGroupsWithInvalidAllocations() {
                return this.serverGroupsWithInvalidAllocations.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAllocations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, allocations, new _validateAllocations_closure1(this, this, decimalPlaces, serverGroupsWithInvalidAllocations));
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroupsWithInvalidAllocations.get()) != false) {
            Boolean pluralize = ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, serverGroupsWithInvalidAllocations.get()), (Object)1);
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, pluralize) != false ? "s" : "", IndyInterface.bootstrap("invoke", "join", 0, serverGroupsWithInvalidAllocations.get(), ", ")}, new String[]{"(Allocation", " invalid for ", ". "})), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, shardBy), decimalPlaces.get()}, new String[]{"Allocations for shard type ", " can have up to ", " decimal places.)"})));
            return false;
        }
        public final class _validateAllocations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateAllocations_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return v;
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAllocations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "round", 0, (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "sum", 0, IndyInterface.bootstrap("invoke", "collect", 0, allocations, new _validateAllocations_closure2(this, this))), Double.class)), decimalPlaces.get()), (Object)1)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Allocations must sum to 1)"}));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object validateServerGroupsCanBeEnabled(Collection<String> serverGroupNames, String loadBalancerName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider appengineClusterProvider, String attribute) {
        void var3_3;
        Reference loadBalancerName2 = new Reference((Object)loadBalancerName);
        Reference credentials2 = new Reference((Object)var3_3);
        Reference appengineClusterProvider2 = new Reference((Object)appengineClusterProvider);
        public final class _validateServerGroupsCanBeEnabled_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateServerGroupsCanBeEnabled_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateServerGroupsCanBeEnabled_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _validateServerGroupsCanBeEnabled_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference appengineClusterProvider;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateServerGroupsCanBeEnabled_closure4(Object _outerInstance, Object _thisObject, Reference appengineClusterProvider, Reference credentials, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.appengineClusterProvider = reference3 = appengineClusterProvider;
                this.credentials = reference2 = credentials;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Map reject, Object serverGroupName) {
                CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, IndyInterface.bootstrap("cast", "()", 0, this.appengineClusterProvider.get()), IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), serverGroupName);
                if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) == false) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "notFound", 0, reject), serverGroupName);
                    return reject;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get())) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 1, serverGroup), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get())), (Object)true)) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "notRegisteredWithLoadBalancer", 0, reject), serverGroupName);
                    return reject;
                }
                return reject;
            }

            @Generated
            public Object call(Map reject, Object serverGroupName) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, reject, serverGroupName);
            }

            @Generated
            public AppengineClusterProvider getAppengineClusterProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appengineClusterProvider.get());
            }

            @Generated
            public AppengineNamedAccountCredentials getCredentials() {
                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateServerGroupsCanBeEnabled_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite rejectedServerGroups = IndyInterface.bootstrap("invoke", "inject", 0, serverGroupNames, IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _validateServerGroupsCanBeEnabled_closure3(this, this)), new _validateServerGroupsCanBeEnabled_closure4(this, this, appengineClusterProvider2, credentials2, loadBalancerName2));
        Boolean valid = true;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "notFound", 0, rejectedServerGroups)) != false) {
            CallSite notFound = IndyInterface.bootstrap("getProperty", "notFound", 0, rejectedServerGroups);
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute, ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, notFound), (Object)1) ? "s" : "", IndyInterface.bootstrap("invoke", "join", 0, notFound, ", ")}, new String[]{"", ".", ".invalid (Server group", " ", " not found)."}));
            valid = false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "notRegisteredWithLoadBalancer", 0, rejectedServerGroups)) != false) {
            CallSite notRegistered = IndyInterface.bootstrap("getProperty", "notRegisteredWithLoadBalancer", 0, rejectedServerGroups);
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute, ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, notRegistered), (Object)1) ? "s" : "", IndyInterface.bootstrap("invoke", "join", 0, notRegistered, ", ")}, new String[]{"", ".", ".invalid (Server group", " ", " "}), new GStringImpl(new Object[]{(String)loadBalancerName2.get()}, new String[]{"not registered with load balancer ", ")."})));
            valid = false;
        }
        return valid;
    }

    public Object validateLoadBalancerCanBeDeleted(String loadBalancerName, String attribute) {
        if (ScriptBytecodeAdapter.compareEqual((Object)loadBalancerName, (Object)"default")) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Cannot delete default service)."}));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object validateInstances(List<String> instanceIds, AppengineNamedAccountCredentials credentials, AppengineInstanceProvider appengineInstanceProvider, String attribute) {
        void var3_3;
        void var2_2;
        Reference instanceIds2 = new Reference(instanceIds);
        Reference credentials2 = new Reference((Object)var2_2);
        Reference appengineInstanceProvider2 = new Reference((Object)var3_3);
        Reference attribute2 = new Reference((Object)attribute);
        public final class _validateInstances_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference appengineInstanceProvider;
            private /* synthetic */ Reference credentials;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstances_closure5(Object _outerInstance, Object _thisObject, Reference appengineInstanceProvider, Reference credentials) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.appengineInstanceProvider = reference2 = appengineInstanceProvider;
                this.credentials = reference = credentials;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getInstance", 0, IndyInterface.bootstrap("cast", "()", 0, this.appengineInstanceProvider.get()), IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), it);
            }

            @Generated
            public AppengineInstanceProvider getAppengineInstanceProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appengineInstanceProvider.get());
            }

            @Generated
            public AppengineNamedAccountCredentials getCredentials() {
                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstances_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite instances = IndyInterface.bootstrap("invoke", "collect", 0, (List)instanceIds2.get(), new _validateInstances_closure5(this, this, appengineInstanceProvider2, credentials2));
        Reference valid = new Reference((Object)true);
        public final class _validateInstances_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceIds;
            private /* synthetic */ Reference attribute;
            private /* synthetic */ Reference valid;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstances_closure6(Object _outerInstance, Object _thisObject, Reference instanceIds, Reference attribute, Reference valid) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.instanceIds = reference3 = instanceIds;
                this.attribute = reference2 = attribute;
                this.valid = reference = valid;
            }

            public Object doCall(AppengineInstance instance, int i) {
                CallSite name = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceIds.get()), i);
                if (IndyInterface.bootstrap("cast", "()", 0, instance) == false) {
                    IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get())}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get()), name}, new String[]{"", ".", ".invalid (Instance ", " not found)."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                    return null;
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "serverGroup", 4, instance)) == false) {
                    IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get())}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get()), name}, new String[]{"", ".", ".invalid (Could not find parent server group for instance ", ")."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, instance), false)) == false) {
                    IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get())}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.attribute.get()), name}, new String[]{"", ".", ".invalid (Could not find parent load balancer for instance ", ")."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                    return bl;
                }
                return null;
            }

            @Generated
            public Object call(AppengineInstance instance, int i) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, instance, i);
            }

            @Generated
            public List getInstanceIds() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceIds.get());
            }

            @Generated
            public String getAttribute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.attribute.get());
            }

            @Generated
            public Object getValid() {
                return this.valid.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstances_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, instances, new _validateInstances_closure6(this, this, instanceIds2, attribute2, valid));
        return valid.get();
    }

    public Object validateServerGroupCanBeDisabled(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, AppengineLoadBalancerProvider loadBalancerProvider, String attribute) {
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, clusterProvider, IndyInterface.bootstrap("getProperty", "name", 4, credentials), IndyInterface.bootstrap("getProperty", "region", 4, credentials), serverGroupName);
        Boolean valid = true;
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " not found)."}));
            valid = false;
            return valid;
        }
        CallSite loadBalancerName = IndyInterface.bootstrap("invoke", "first", 1, IndyInterface.bootstrap("getProperty", "loadBalancers", 1, serverGroup));
        CallSite loadBalancer = IndyInterface.bootstrap("invoke", "getLoadBalancer", 0, loadBalancerProvider, IndyInterface.bootstrap("getProperty", "name", 4, credentials), loadBalancerName);
        if (IndyInterface.bootstrap("cast", "()", 0, loadBalancer) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute, loadBalancerName, serverGroupName}, new String[]{"", ".", ".invalid (Could not find parent load balancer ", " for server group ", ")."}));
            valid = false;
            return valid;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "allocations", 1, IndyInterface.bootstrap("getProperty", "split", 1, loadBalancer)), serverGroupName), (Object)((Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, true, Double.class))))) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " is the only server group "}), new GStringImpl(new Object[]{loadBalancerName}, new String[]{"receiving traffic from load balancer ", ")."})));
            valid = false;
        }
        return valid;
    }

    public Object validateServingStatusCanBeChanged(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, clusterProvider, IndyInterface.bootstrap("getProperty", "name", 4, credentials), IndyInterface.bootstrap("getProperty", "region", 4, credentials), serverGroupName);
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " not found)."}));
            return false;
        }
        Boolean isFlex = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "env", 0, serverGroup), (Object)IndyInterface.bootstrap("getProperty", "FLEXIBLE", 0, AppengineServerGroup.Environment.class));
        Boolean usesManualScaling = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 1, IndyInterface.bootstrap("getProperty", "scalingPolicy", 0, serverGroup)), (Object)IndyInterface.bootstrap("getProperty", "MANUAL", 0, ScalingPolicyType.class));
        Boolean usesBasicScaling = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 1, IndyInterface.bootstrap("getProperty", "scalingPolicy", 0, serverGroup)), (Object)IndyInterface.bootstrap("getProperty", "BASIC", 0, ScalingPolicyType.class));
        if (!(DefaultTypeTransformation.booleanUnbox((Object)isFlex) || DefaultTypeTransformation.booleanUnbox((Object)usesBasicScaling) || DefaultTypeTransformation.booleanUnbox((Object)usesManualScaling))) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Only server groups that use the App Engine flexible environment,"}), " or use basic or manual scaling can be started or stopped)."));
            return false;
        }
        return true;
    }

    public Object validateShardBy(AppengineTrafficSplit split, Boolean migrateTraffic, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, split) == false) {
            return true;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)migrateTraffic) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "shardBy", 4, split), attribute)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (A shardBy value must be specified for gradual traffic migration)."}));
            return false;
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "keySet", 1, IndyInterface.bootstrap("getProperty", "allocations", 4, split)));
        Object targetNumberOfEnabledServerGroups = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)targetNumberOfEnabledServerGroups, (Object)1) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "shardBy", 4, split), attribute)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (A shardBy value must be specified if traffic "}), "will be split between multiple server groups)."));
            return false;
        }
        return true;
    }

    public Object validateGradualMigrationIsAllowed(AppengineTrafficSplit split, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "allocations", 4, split), "split.allocations")) == false) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("getProperty", "allocations", 4, split))), (Object)1)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), "(Cannot gradually migrate traffic to multiple server groups)."));
            return false;
        }
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, clusterProvider, IndyInterface.bootstrap("getProperty", "name", 4, credentials), IndyInterface.bootstrap("getProperty", "region", 4, credentials), IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("getProperty", "allocations", 4, split)), false));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "allowsGradualTrafficMigration", 0, serverGroup)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), "(Cannot gradually migrate traffic to this server group. "), "Gradual migration is allowed only for server groups in the App Engine standard "), "environment that use automatic scaling and have warmup requests enabled)."));
            return false;
        }
        return true;
    }

    public Object validateServerGroupSupportsAutoscalingPolicyUpsert(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroupName) == false) {
            return null;
        }
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, clusterProvider, IndyInterface.bootstrap("getProperty", "name", 4, credentials), IndyInterface.bootstrap("getProperty", "region", 4, credentials), serverGroupName);
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) != false) {
            Boolean isStandard = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "env", 0, serverGroup), (Object)IndyInterface.bootstrap("getProperty", "FLEXIBLE", 0, AppengineServerGroup.Environment.class));
            Boolean usesAutomaticScaling = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 1, IndyInterface.bootstrap("getProperty", "scalingPolicy", 0, serverGroup)), (Object)IndyInterface.bootstrap("getProperty", "AUTOMATIC", 0, ScalingPolicyType.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)isStandard) && DefaultTypeTransformation.booleanUnbox((Object)usesAutomaticScaling)) {
                return true;
            }
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), "(Autoscaling policies can only be updated for "), "server groups in the App Engine standard environment that use automatic scaling)."));
            return false;
        }
        IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notFound "}), new GStringImpl(new Object[]{serverGroupName}, new String[]{"(Cannot find server group ", ".)"})));
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardAppengineAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string = "^[a-z0-9]+$";
        prefixPattern = string;
        String string2 = "^[a-z0-9]+([-a-z0-9]*[a-z0-9])?$";
        namePattern = string2;
    }

    @Generated
    public static Object getNamePattern() {
        return namePattern;
    }

    @Generated
    public static Object getPrefixPattern() {
        return prefixPattern;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public void setContext(String string) {
        this.context = string;
    }

    @Generated
    public ValidationErrors getErrors() {
        return this.errors;
    }

    @Generated
    public void setErrors(ValidationErrors validationErrors) {
        this.errors = validationErrors;
    }
}

