/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy.ops;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.appengine.config.AppengineConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.deploy.description.DeployAppengineConfigDescription;
import com.netflix.spinnaker.clouddriver.appengine.deploy.exception.AppengineOperationException;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DeployAppengineConfigAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "DEPLOY_APPENGINE_CONFIG";
    private DeployAppengineConfigDescription description;
    @Autowired
    private ArtifactDownloader artifactDownloader;
    @Autowired
    private Registry registry;
    @Autowired
    private AppengineJobExecutor jobExecutor;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public DeployAppengineConfigAtomicOperation(DeployAppengineConfigDescription description) {
        this.description = description;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Void operate(List<Void> priorOutputs) {
        String serviceAccount = this.description.getCredentials().getServiceAccountEmail();
        String region = this.description.getCredentials().getRegion();
        this.registry.counter(this.registry.createId("appengine.deployConfigStart", new String[]{"account", serviceAccount, "region", region})).increment();
        long startTime = this.registry.clock().monotonicTime();
        AppengineConfigurationProperties.ManagedAccount.GcloudReleaseTrack gCloudReleaseTrack = this.description.getCredentials().getGcloudReleaseTrack();
        ArrayList<String> deployCommand = new ArrayList<String>();
        deployCommand.add(this.description.getCredentials().getGcloudPath());
        if (gCloudReleaseTrack != null && gCloudReleaseTrack != AppengineConfigurationProperties.ManagedAccount.GcloudReleaseTrack.STABLE) {
            deployCommand.add(gCloudReleaseTrack.toString().toLowerCase());
        }
        deployCommand.add("app");
        deployCommand.add("deploy");
        Path directory = this.createEmptyDirectory();
        String success = "false";
        try {
            if (this.description.getCronArtifact() != null) {
                DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Downloading cron configuration...");
                File cronFile = this.downloadFileToDirectory(this.description.getCronArtifact(), directory, SupportedConfigTypes.CRON);
                deployCommand.add(cronFile.getPath());
            }
            if (this.description.getDispatchArtifact() != null) {
                DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Downloading dispatch configuration...");
                File dispatchFile = this.downloadFileToDirectory(this.description.getDispatchArtifact(), directory, SupportedConfigTypes.DISPATCH);
                deployCommand.add(dispatchFile.getPath());
            }
            if (this.description.getIndexArtifact() != null) {
                DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Downloading index configuration...");
                File indexFile = this.downloadFileToDirectory(this.description.getIndexArtifact(), directory, SupportedConfigTypes.INDEX);
                deployCommand.add(indexFile.getPath());
            }
            if (this.description.getQueueArtifact() != null) {
                DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Downloading queue configuration...");
                File queueFile = this.downloadFileToDirectory(this.description.getQueueArtifact(), directory, SupportedConfigTypes.QUEUE);
                deployCommand.add(queueFile.getPath());
            }
            deployCommand.add("--project=" + this.description.getCredentials().getProject());
            deployCommand.add("--account=" + this.description.getCredentials().getServiceAccountEmail());
            DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deploying configuration...");
            this.jobExecutor.runCommand(deployCommand);
            success = "true";
            DeployAppengineConfigAtomicOperation.getTask().updateStatus(BASE_PHASE, "Done deploying configuration");
        }
        catch (Exception e) {
            try {
                throw new AppengineOperationException("Failed to deploy to App Engine with command: " + String.valueOf(deployCommand));
            }
            catch (Throwable throwable) {
                try {
                    long duration = this.registry.clock().monotonicTime() - startTime;
                    this.registry.timer(this.registry.createId("appengine.deployConfig", new String[]{"account", serviceAccount, "success", success})).record(duration, TimeUnit.NANOSECONDS);
                    FileUtils.cleanDirectory((File)directory.toFile());
                    FileUtils.forceDelete((File)directory.toFile());
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new AppengineOperationException("Failed to clean up and delete directory: " + String.valueOf(directory));
                }
            }
        }
        try {
            long duration = this.registry.clock().monotonicTime() - startTime;
            this.registry.timer(this.registry.createId("appengine.deployConfig", new String[]{"account", serviceAccount, "success", success})).record(duration, TimeUnit.NANOSECONDS);
            FileUtils.cleanDirectory((File)directory.toFile());
            FileUtils.forceDelete((File)directory.toFile());
            return null;
        }
        catch (Exception e) {
            throw new AppengineOperationException("Failed to clean up and delete directory: " + String.valueOf(directory));
        }
    }

    Path createEmptyDirectory() {
        Path path;
        try {
            path = Files.createTempDirectory("appengineconfig-", new FileAttribute[0]);
            FileUtils.cleanDirectory((File)path.toFile());
        }
        catch (IOException ex) {
            throw new AppengineOperationException("Failed to create directory");
        }
        return path;
    }

    File downloadFileToDirectory(Artifact artifact, Path directory, SupportedConfigTypes type) {
        File targetFile;
        try {
            InputStream inStream = this.artifactDownloader.download(artifact);
            targetFile = new File(String.valueOf(directory) + "/" + type.toString().toLowerCase() + ".yaml");
            FileUtils.copyInputStreamToFile((InputStream)inStream, (File)targetFile);
            IOUtils.closeQuietly((Closeable)inStream);
        }
        catch (IOException e) {
            throw new AppengineOperationException("Failed to download cron configuration");
        }
        return targetFile;
    }

    static enum SupportedConfigTypes {
        CRON,
        QUEUE,
        DISPATCH,
        INDEX;

    }
}

