/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.appengine.provider.AppengineProvider;
import com.netflix.spinnaker.clouddriver.appengine.provider.agent.AppengineLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.appengine.provider.agent.AppenginePlatformApplicationCachingAgent;
import com.netflix.spinnaker.clouddriver.appengine.provider.agent.AppengineServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.appengine.security.AppengineNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class AppengineCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<AppengineNamedAccountCredentials> {
    private final AppengineProvider appengineProvider;
    private final ObjectMapper objectMapper;
    private final Registry registry;

    public void credentialsAdded(AppengineNamedAccountCredentials credentials) {
        this.addAgentFor(credentials);
    }

    public void credentialsUpdated(AppengineNamedAccountCredentials credentials) {
        this.appengineProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.addAgentFor(credentials);
    }

    public void credentialsDeleted(AppengineNamedAccountCredentials credentials) {
        this.appengineProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
    }

    private void addAgentFor(AppengineNamedAccountCredentials credentials) {
        this.appengineProvider.addAgents(List.of(new AppengineServerGroupCachingAgent(credentials.getName(), credentials, this.objectMapper, this.registry), new AppengineLoadBalancerCachingAgent(credentials.getName(), credentials, this.objectMapper, this.registry), new AppenginePlatformApplicationCachingAgent(credentials.getName(), credentials, this.objectMapper)));
    }

    @Generated
    public AppengineCredentialsLifecycleHandler(AppengineProvider appengineProvider, ObjectMapper objectMapper, Registry registry) {
        this.appengineProvider = appengineProvider;
        this.objectMapper = objectMapper;
        this.registry = registry;
    }
}

