/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.bitbucket;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class BitbucketArtifactAccount
implements ArtifactAccount,
BasicAuth {
    private final String name;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Optional<String> usernamePasswordFile;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    BitbucketArtifactAccount(String name, String username, String password, String usernamePasswordFile) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password));
        this.usernamePasswordFile = Optional.ofNullable(Strings.emptyToNull((String)usernamePasswordFile));
    }

    @Generated
    public static BitbucketArtifactAccountBuilder builder() {
        return new BitbucketArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Optional<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Optional<String> getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitbucketArtifactAccount)) {
            return false;
        }
        BitbucketArtifactAccount other = (BitbucketArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<String> this$password = this.getPassword();
        Optional<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        Optional<String> this$usernamePasswordFile = this.getUsernamePasswordFile();
        Optional<String> other$usernamePasswordFile = other.getUsernamePasswordFile();
        return !(this$usernamePasswordFile == null ? other$usernamePasswordFile != null : !((Object)this$usernamePasswordFile).equals(other$usernamePasswordFile));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        Optional<String> $usernamePasswordFile = this.getUsernamePasswordFile();
        result = result * 59 + ($usernamePasswordFile == null ? 43 : ((Object)$usernamePasswordFile).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BitbucketArtifactAccount(name=" + this.getName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", usernamePasswordFile=" + this.getUsernamePasswordFile() + ")";
    }

    @Generated
    public static class BitbucketArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String usernamePasswordFile;

        @Generated
        BitbucketArtifactAccountBuilder() {
        }

        @Generated
        public BitbucketArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return this;
        }

        @Generated
        public BitbucketArtifactAccount build() {
            return new BitbucketArtifactAccount(this.name, this.username, this.password, this.usernamePasswordFile);
        }

        @Generated
        public String toString() {
            return "BitbucketArtifactAccount.BitbucketArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ")";
        }
    }
}

