/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.netflix.spinnaker.clouddriver.artifacts.CredentialReader;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;

@NonnullByDefault
public interface BasicAuth {
    public Optional<String> getUsername();

    public Optional<String> getPassword();

    public Optional<String> getUsernamePasswordFile();

    default public Optional<String> getBasicAuthHeader() {
        Object usernamePassword = null;
        if (this.getUsernamePasswordFile().isPresent()) {
            usernamePassword = CredentialReader.credentialsFromFile(this.getUsernamePasswordFile().get());
        } else if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
            usernamePassword = this.getUsername().get() + ":" + this.getPassword().get();
        }
        return Optional.ofNullable(usernamePassword).map(s -> "Basic " + Base64.encodeBase64String((byte[])s.getBytes()));
    }
}

