/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.jenkins;

import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.squareup.okhttp.OkHttpClient;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"jenkins.enabled"})
@EnableConfigurationProperties(value={JenkinsProperties.class})
class JenkinsArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JenkinsArtifactConfiguration.class);
    private final JenkinsProperties jenkinsProperties;

    @Bean
    public CredentialsTypeProperties<JenkinsArtifactCredentials, JenkinsArtifactAccount> jenkinsCredentialsProperties(OkHttpClient okHttpClient) {
        return CredentialsTypeProperties.builder().type("artifacts-jenkins").credentialsClass(JenkinsArtifactCredentials.class).credentialsDefinitionClass(JenkinsArtifactAccount.class).defaultCredentialsSource(() -> this.jenkinsProperties.getMasters().stream().map(m -> new JenkinsArtifactAccount(m.getName(), m.getUsername(), m.getPassword(), m.getAddress())).collect(Collectors.toList())).credentialsParser(a -> {
            try {
                return new JenkinsArtifactCredentials((JenkinsArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating jenkins artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public JenkinsArtifactConfiguration(JenkinsProperties jenkinsProperties) {
        this.jenkinsProperties = jenkinsProperties;
    }
}

