/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.github;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.github.GitHubArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.squareup.okhttp.OkHttpClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.github.enabled"})
@EnableConfigurationProperties(value={GitHubArtifactProviderProperties.class})
class GitHubArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitHubArtifactConfiguration.class);
    private final GitHubArtifactProviderProperties gitHubArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<GitHubArtifactCredentials, GitHubArtifactAccount> githubCredentialsProperties(OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        return CredentialsTypeProperties.builder().type("artifacts-github").credentialsClass(GitHubArtifactCredentials.class).credentialsDefinitionClass(GitHubArtifactAccount.class).defaultCredentialsSource(this.gitHubArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new GitHubArtifactCredentials((GitHubArtifactAccount)a, okHttpClient, objectMapper);
            }
            catch (Exception e) {
                log.warn("Failure instantiating GitHub artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public GitHubArtifactConfiguration(GitHubArtifactProviderProperties gitHubArtifactProviderProperties) {
        this.gitHubArtifactProviderProperties = gitHubArtifactProviderProperties;
    }
}

