/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.credentials.CompositeCredentialsRepository;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.exceptions.MissingCredentialsException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCredentialsRepository
extends CompositeCredentialsRepository<ArtifactCredentials> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArtifactCredentialsRepository.class);

    public ArtifactCredentialsRepository(List<CredentialsRepository<? extends ArtifactCredentials>> repositories) {
        super(repositories);
    }

    public ArtifactCredentials getCredentialsForType(String name, String artifactType) {
        if (Strings.isNullOrEmpty((String)name)) {
            String message = "An artifact account must be supplied to download this artifact: " + name;
            log.debug(message);
            throw new IllegalArgumentException(message);
        }
        return this.getAllCredentials().stream().filter(a -> a.getName().equals(name) && a.handlesType(artifactType)).findFirst().orElseThrow(() -> new MissingCredentialsException("Credentials '" + name + "' supporting artifact type '" + artifactType + "' cannot be found"));
    }
}

