/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BaseHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.exceptions.FailedDownloadException;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.io.InputStream;

@NonnullByDefault
public abstract class SimpleHttpArtifactCredentials<T extends ArtifactAccount>
extends BaseHttpArtifactCredentials<T> {
    protected SimpleHttpArtifactCredentials(OkHttpClient okHttpClient, T account) {
        super(okHttpClient, account);
    }

    protected HttpUrl getDownloadUrl(Artifact artifact) throws IOException {
        HttpUrl url = HttpUrl.parse((String)artifact.getReference());
        if (url == null) {
            throw new IllegalArgumentException("Malformed content URL in reference: " + artifact.getReference() + ". Read more here https://www.spinnaker.io/reference/artifacts/types/");
        }
        return url;
    }

    public final InputStream download(Artifact artifact) throws IOException {
        HttpUrl downloadUrl = this.getDownloadUrl(artifact);
        try {
            return this.fetchUrl(downloadUrl).byteStream();
        }
        catch (IOException e) {
            throw new FailedDownloadException("Unable to download the contents of artifact " + artifact + ": " + e.getMessage(), e);
        }
    }
}

