/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.jenkins;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.SimpleHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.jenkins.JenkinsArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class JenkinsArtifactCredentials
extends SimpleHttpArtifactCredentials<JenkinsArtifactAccount>
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JenkinsArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-jenkins";
    private static final String TYPE = "jenkins/file";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"jenkins/file");
    private final JenkinsArtifactAccount jenkinsArtifactAccount;

    JenkinsArtifactCredentials(JenkinsArtifactAccount account, OkHttpClient okHttpClient) {
        super(okHttpClient, account);
        this.jenkinsArtifactAccount = account;
        this.name = account.getName();
    }

    @Override
    protected HttpUrl getDownloadUrl(Artifact artifact) {
        Object formattedJenkinsAddress = this.jenkinsArtifactAccount.getAddress().endsWith("/") ? this.jenkinsArtifactAccount.getAddress() : this.jenkinsArtifactAccount.getAddress() + "/";
        Object formattedReference = artifact.getReference().startsWith("/") ? artifact.getReference() : "/" + artifact.getReference();
        String buildUrl = (String)formattedJenkinsAddress + "job/" + artifact.getName() + "/" + artifact.getVersion() + "/artifact" + (String)formattedReference;
        HttpUrl url = HttpUrl.parse((String)buildUrl);
        if (url == null) {
            throw new IllegalArgumentException("Malformed content URL in reference: " + buildUrl + ". Read more here https://www.spinnaker.io/reference/artifacts/types/");
        }
        return url;
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

