/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.oracle.OracleArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.oracle.enabled"})
@EnableConfigurationProperties(value={OracleArtifactProviderProperties.class})
class OracleArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OracleArtifactConfiguration.class);
    private final OracleArtifactProviderProperties oracleArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<OracleArtifactCredentials, OracleArtifactAccount> oracleCredentialsProperties(String clouddriverUserAgentApplicationName) {
        return CredentialsTypeProperties.builder().type("artifacts-oracle").credentialsClass(OracleArtifactCredentials.class).credentialsDefinitionClass(OracleArtifactAccount.class).defaultCredentialsSource(this.oracleArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new OracleArtifactCredentials(clouddriverUserAgentApplicationName, (OracleArtifactAccount)a);
            }
            catch (Exception e) {
                log.warn("Failure instantiating oracle artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public OracleArtifactConfiguration(OracleArtifactProviderProperties oracleArtifactProviderProperties) {
        this.oracleArtifactProviderProperties = oracleArtifactProviderProperties;
    }
}

