/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;

@NonnullByDefault
public interface ArtifactCredentials
extends Credentials {
    public String getName();

    public List<String> getTypes();

    public InputStream download(Artifact var1) throws IOException;

    default public Optional<String> resolveArtifactName(Artifact artifact) {
        return Optional.ofNullable(artifact.getName());
    }

    default public Optional<String> resolveArtifactVersion(Artifact artifact) {
        return Optional.ofNullable(artifact.getVersion());
    }

    @JsonIgnore
    default public List<String> getArtifactNames() {
        throw new NotImplementedException("Artifact names are not supported for artifact types that '" + this.getName() + "' account handles");
    }

    @JsonIgnore
    default public List<String> getArtifactVersions(String artifactName) {
        throw new NotImplementedException("Artifact versions are not supported for artifact types that '" + this.getName() + "' account handles");
    }

    default public boolean handlesType(String type) {
        return this.getTypes().contains(type);
    }
}

