/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.front50;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
final class Front50ArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Front50ArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-front50";
    private static final String ACCOUNT_NAME = "front50ArtifactCredentials";
    private static final String URL_PREFIX = "spinnaker://";
    private final String name = "front50ArtifactCredentials";
    private final ImmutableList<String> types = ImmutableList.of((Object)"front50/pipelineTemplate");
    @JsonIgnore
    private final Front50Service front50Service;
    @JsonIgnore
    private final ObjectMapper objectMapper;

    Front50ArtifactCredentials(ObjectMapper objectMapper, Front50Service front50Service) {
        this.objectMapper = objectMapper;
        this.front50Service = front50Service;
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        Map pipelineTemplate;
        String reference = Strings.nullToEmpty((String)artifact.getReference());
        if (!reference.startsWith(URL_PREFIX)) {
            throw new IllegalArgumentException(String.format("'front50/pipelineTemplate' artifacts must be specified with a 'reference' starting with %s, got: %s'", URL_PREFIX, artifact));
        }
        String artifactId = reference.substring(URL_PREFIX.length());
        if (artifactId.contains("@sha256:")) {
            SplitResult result = this.splitReferenceOnToken(artifactId, "@sha256:");
            pipelineTemplate = (Map)AuthenticatedRequest.allowAnonymous(() -> this.front50Service.getV2PipelineTemplate(result.pipelineTemplateId, "", result.version));
        } else if (artifactId.contains(":")) {
            SplitResult result = this.splitReferenceOnToken(artifactId, ":");
            pipelineTemplate = (Map)AuthenticatedRequest.allowAnonymous(() -> this.front50Service.getV2PipelineTemplate(result.pipelineTemplateId, result.version, ""));
        } else {
            pipelineTemplate = (Map)AuthenticatedRequest.allowAnonymous(() -> this.front50Service.getV2PipelineTemplate(artifactId, "", ""));
        }
        return new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)pipelineTemplate));
    }

    @Override
    public List<String> getArtifactNames() {
        return this.front50Service.listV2PipelineTemplates(Collections.singletonList("global")).stream().map(t -> (String)t.get("id")).distinct().collect(Collectors.toList());
    }

    private SplitResult splitReferenceOnToken(String reference, String token) {
        String[] refParts = reference.split(token);
        if (refParts.length != 2) {
            throw new IllegalArgumentException("Malformed Front50 artifact reference: " + reference);
        }
        return new SplitResult(refParts[0], refParts[1]);
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    private static class SplitResult {
        private String pipelineTemplateId;
        private String version;

        @Generated
        public String getPipelineTemplateId() {
            return this.pipelineTemplateId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public SplitResult setPipelineTemplateId(String pipelineTemplateId) {
            this.pipelineTemplateId = pipelineTemplateId;
            return this;
        }

        @Generated
        public SplitResult setVersion(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SplitResult)) {
                return false;
            }
            SplitResult other = (SplitResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pipelineTemplateId = this.getPipelineTemplateId();
            String other$pipelineTemplateId = other.getPipelineTemplateId();
            if (this$pipelineTemplateId == null ? other$pipelineTemplateId != null : !this$pipelineTemplateId.equals(other$pipelineTemplateId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SplitResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pipelineTemplateId = this.getPipelineTemplateId();
            result = result * 59 + ($pipelineTemplateId == null ? 43 : $pipelineTemplateId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Front50ArtifactCredentials.SplitResult(pipelineTemplateId=" + this.getPipelineTemplateId() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public SplitResult(String pipelineTemplateId, String version) {
            this.pipelineTemplateId = pipelineTemplateId;
            this.version = version;
        }
    }
}

