/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.DiskFreeingInputStream;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class IvyArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IvyArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-ivy";
    private final ImmutableList<String> types = ImmutableList.of((Object)"ivy/file");
    private final IvyArtifactAccount account;
    private final Supplier<Path> cacheBuilder;

    public IvyArtifactCredentials(IvyArtifactAccount account) {
        this(account, () -> Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()));
    }

    public IvyArtifactCredentials(IvyArtifactAccount account, Supplier<Path> cacheBuilder) {
        this.cacheBuilder = cacheBuilder;
        IvyArtifactCredentials.redirectIvyLogsToSlf4j();
        this.account = account;
    }

    private static void redirectIvyLogsToSlf4j() {
        Message.setDefaultLogger((MessageLogger)new AbstractMessageLogger(){
            private final Logger logger = LoggerFactory.getLogger((String)"org.apache.ivy");

            protected void doProgress() {
            }

            protected void doEndProgress(String msg) {
                this.log(msg, 2);
            }

            public void log(String msg, int level) {
                switch (level) {
                    case 0: {
                        this.logger.error(msg);
                        break;
                    }
                    case 1: {
                        this.logger.warn(msg);
                        break;
                    }
                    case 2: {
                        this.logger.info(msg);
                        break;
                    }
                    case 4: {
                        this.logger.debug(msg);
                        break;
                    }
                    case 3: {
                        this.logger.trace(msg);
                    }
                }
            }

            public void rawlog(String msg, int level) {
                this.log(msg, level);
            }
        });
    }

    @Override
    public InputStream download(Artifact artifact) {
        Path cacheDir = this.cacheBuilder.get();
        Ivy ivy = this.account.getSettings().toIvy(cacheDir);
        String[] parts = artifact.getReference().split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Ivy artifact reference must have a group, artifact, and version separated by ':'");
        }
        ModuleRevisionId mrid = new ModuleRevisionId(new ModuleId(parts[0], parts[1]), parts[2]);
        try {
            ResolveReport report = ivy.resolve(mrid, (ResolveOptions)new ResolveOptions().setTransitive(false).setConfs((String[])this.account.getResolveConfigurations().toArray((Object[])new String[0])).setLog("download-only"), true);
            return Arrays.stream(report.getAllArtifactsReports()).findFirst().map(rep -> {
                try {
                    return new DiskFreeingInputStream(new FileInputStream(rep.getLocalFile()), cacheDir);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }).orElseThrow(() -> new IllegalArgumentException("Unable to resolve artifact for reference '" + artifact.getReference() + "'"));
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return this.account.getName();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

