/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.jenkins;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class JenkinsArtifactAccount
implements ArtifactAccount,
BasicAuth {
    private final String name;
    private final Optional<String> username;
    private final Optional<String> password;
    private final String address;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    JenkinsArtifactAccount(String name, String username, String password, String address) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password));
        this.address = Strings.nullToEmpty((String)address);
    }

    @Override
    public Optional<String> getUsernamePasswordFile() {
        return Optional.empty();
    }

    @Generated
    public static JenkinsArtifactAccountBuilder builder() {
        return new JenkinsArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Optional<String> getPassword() {
        return this.password;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JenkinsArtifactAccount)) {
            return false;
        }
        JenkinsArtifactAccount other = (JenkinsArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<String> this$password = this.getPassword();
        Optional<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JenkinsArtifactAccount(name=" + this.getName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", address=" + this.getAddress() + ")";
    }

    @Generated
    public static class JenkinsArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String address;

        @Generated
        JenkinsArtifactAccountBuilder() {
        }

        @Generated
        public JenkinsArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public JenkinsArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public JenkinsArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public JenkinsArtifactAccountBuilder address(String address) {
            this.address = address;
            return this;
        }

        @Generated
        public JenkinsArtifactAccount build() {
            return new JenkinsArtifactAccount(this.name, this.username, this.password, this.address);
        }

        @Generated
        public String toString() {
            return "JenkinsArtifactAccount.JenkinsArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", address=" + this.address + ")";
        }
    }
}

