/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.google.common.base.Supplier;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

class OracleArtifactClient {
    private final Client client;

    OracleArtifactClient(String userId, String sshPrivateKeyFilePath, String privateKeyPassphrase, String fingerprint, String tenancyId) {
        SimplePrivateKeySupplier privateKeySupplier = new SimplePrivateKeySupplier(sshPrivateKeyFilePath);
        SimpleAuthenticationDetailsProvider provider = SimpleAuthenticationDetailsProvider.builder().userId(userId).fingerprint(fingerprint).privateKeySupplier((Supplier)privateKeySupplier).passPhrase(privateKeyPassphrase).tenantId(tenancyId).build();
        RequestSigner requestSigner = DefaultRequestSigner.createRequestSigner((BasicAuthenticationDetailsProvider)provider);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        this.client = new Client((ClientHandler)new URLConnectionClientHandler(), (ClientConfig)clientConfig);
        this.client.addFilter((ClientFilter)new RequestSigningFilter(requestSigner));
    }

    InputStream readObject(URI uri) {
        WebResource wr = this.client.resource(uri);
        wr.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE});
        return (InputStream)wr.get(InputStream.class);
    }

    private class RequestSigningFilter
    extends ClientFilter {
        private final RequestSigner signer;

        private RequestSigningFilter(RequestSigner requestSigner) {
            this.signer = requestSigner;
        }

        public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
            HashMap stringHeaders = new HashMap();
            for (String key : cr.getHeaders().keySet()) {
                ArrayList<String> vals = new ArrayList<String>();
                for (Object val : (List)cr.getHeaders().get((Object)key)) {
                    vals.add((String)val);
                }
                stringHeaders.put(key, vals);
            }
            Map signedHeaders = this.signer.signRequest(cr.getURI(), cr.getMethod(), stringHeaders, cr.getEntity());
            for (String key : signedHeaders.keySet()) {
                cr.getHeaders().putSingle((Object)key, signedHeaders.get(key));
            }
            return this.getNext().handle(cr);
        }
    }
}

