/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.clouddriver.artifacts.config.TokenAuth;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpArtifactCredentials<T extends ArtifactAccount> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseHttpArtifactCredentials.class);
    @JsonIgnore
    private final OkHttpClient okHttpClient;
    @JsonIgnore
    private final T account;

    protected BaseHttpArtifactCredentials(OkHttpClient okHttpClient, T account) {
        this.okHttpClient = okHttpClient;
        this.account = account;
    }

    private Optional<String> getAuthHeader(ArtifactAccount account) {
        Optional<String> authHeader = Optional.empty();
        if (account instanceof TokenAuth) {
            TokenAuth tokenAuth = (TokenAuth)((Object)account);
            authHeader = tokenAuth.getTokenAuthHeader();
        }
        if (!authHeader.isPresent() && account instanceof BasicAuth) {
            BasicAuth basicAuth = (BasicAuth)((Object)account);
            authHeader = basicAuth.getBasicAuthHeader();
        }
        return authHeader;
    }

    protected Headers getHeaders(T account) {
        Headers.Builder headers = new Headers.Builder();
        Optional<String> authHeader = this.getAuthHeader((ArtifactAccount)account);
        if (authHeader.isPresent()) {
            headers.set("Authorization", authHeader.get());
            log.info("Loaded credentials for artifact account {}", (Object)account.getName());
        } else {
            log.info("No credentials included for artifact account {}", (Object)account.getName());
        }
        return headers.build();
    }

    protected HttpUrl parseUrl(String stringUrl) {
        HttpUrl httpUrl = HttpUrl.parse((String)stringUrl);
        if (httpUrl == null) {
            throw new IllegalArgumentException("Malformed URL: " + stringUrl);
        }
        return httpUrl;
    }

    protected ResponseBody fetchUrl(String url) throws IOException {
        return this.fetchUrl(this.parseUrl(url));
    }

    protected ResponseBody fetchUrl(HttpUrl url) throws IOException {
        Request request = new Request.Builder().headers(this.getHeaders(this.account)).url(url).build();
        Response downloadResponse = this.okHttpClient.newCall(request).execute();
        if (!downloadResponse.isSuccessful()) {
            downloadResponse.body().close();
            throw new IOException(String.format("Received %d status code from %s", downloadResponse.code(), url.host()));
        }
        return downloadResponse.body();
    }
}

