/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.docker;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.docker.DockerArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
final class DockerArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-docker";
    public static final String TYPE = "docker/image";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"docker/image");

    DockerArtifactCredentials(DockerArtifactAccount account) {
        this.name = account.getName();
    }

    @Override
    public InputStream download(Artifact artifact) {
        throw new UnsupportedOperationException("Docker references are passed on to cloud platforms who retrieve images directly");
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerArtifactCredentials)) {
            return false;
        }
        DockerArtifactCredentials other = (DockerArtifactCredentials)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ImmutableList<String> this$types = this.getTypes();
        ImmutableList<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !this$types.equals(other$types));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ImmutableList<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : $types.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DockerArtifactCredentials(name=" + this.getName() + ", types=" + this.getTypes() + ")";
    }
}

