/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.exceptions.MissingCredentialsException;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ArtifactDownloader {
    private final ArtifactCredentialsRepository artifactCredentialsRepository;

    public InputStream download(Artifact artifact) throws IOException {
        try {
            return this.artifactCredentialsRepository.getCredentialsForType(artifact.getArtifactAccount(), artifact.getType()).download(artifact);
        }
        catch (MissingCredentialsException e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    @Generated
    public ArtifactDownloader(ArtifactCredentialsRepository artifactCredentialsRepository) {
        this.artifactCredentialsRepository = artifactCredentialsRepository;
    }
}

