/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.docker;

import com.netflix.spinnaker.clouddriver.artifacts.docker.DockerArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.docker.DockerArtifactCredentials;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.NoopCredentialsLifecycleHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${kubernetes.enabled:false} || ${cloudrun.enabled:false} || ${dockerRegistry.enabled:false}")
class DockerArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerArtifactConfiguration.class);

    @Bean
    public CredentialsRepository<DockerArtifactCredentials> dockerArtifactCredentialsRepository() {
        MapBackedCredentialsRepository repository = new MapBackedCredentialsRepository("artifacts-docker", (CredentialsLifecycleHandler)new NoopCredentialsLifecycleHandler());
        repository.save((Credentials)new DockerArtifactCredentials(new DockerArtifactAccount()));
        return repository;
    }

    @Generated
    public DockerArtifactConfiguration() {
    }
}

