/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitlab.GitlabArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.squareup.okhttp.OkHttpClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.gitlab.enabled"})
@EnableConfigurationProperties(value={GitlabArtifactProviderProperties.class})
class GitlabArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitlabArtifactConfiguration.class);
    private final GitlabArtifactProviderProperties gitlabArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<GitlabArtifactCredentials, GitlabArtifactAccount> gitlabCredentialsProperties(OkHttpClient okHttpClient) {
        return CredentialsTypeProperties.builder().type("artifacts-gitlab").credentialsClass(GitlabArtifactCredentials.class).credentialsDefinitionClass(GitlabArtifactAccount.class).defaultCredentialsSource(this.gitlabArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new GitlabArtifactCredentials((GitlabArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating Gitlab artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public GitlabArtifactConfiguration(GitlabArtifactProviderProperties gitlabArtifactProviderProperties) {
        this.gitlabArtifactProviderProperties = gitlabArtifactProviderProperties;
    }
}

