/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.config.BaseHttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.exceptions.FailedDownloadException;
import com.netflix.spinnaker.clouddriver.artifacts.helm.HelmArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.helm.IndexParser;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class HelmArtifactCredentials
extends BaseHttpArtifactCredentials<HelmArtifactAccount>
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelmArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-helm";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"helm/chart", (Object)"helm/index");
    @JsonIgnore
    private final IndexParser indexParser;

    @Override
    public boolean handlesType(String type) {
        return this.types.contains((Object)type);
    }

    public HelmArtifactCredentials(HelmArtifactAccount account, OkHttpClient okHttpClient) {
        super(okHttpClient, account);
        this.name = account.getName();
        this.indexParser = new IndexParser(account.getRepository());
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        InputStream index = this.downloadIndex();
        if ("helm/index".equals(artifact.getType())) {
            return index;
        }
        List<String> urls = this.indexParser.findUrls(index, artifact.getName(), artifact.getVersion());
        for (String url : urls) {
            try {
                ResponseBody downloadResponse = this.fetchUrl(url);
                return downloadResponse.byteStream();
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid url: ", (Object)url);
            }
        }
        throw new FailedDownloadException("Unable to download the contents of artifact");
    }

    @Override
    public List<String> getArtifactNames() {
        List<String> names;
        try {
            InputStream index = this.downloadIndex();
            names = this.indexParser.findNames(index);
        }
        catch (IOException e) {
            throw new NotFoundException("Failed to download chart names for '" + this.name + "' account", (Throwable)e);
        }
        return names;
    }

    @Override
    public List<String> getArtifactVersions(String artifactName) {
        List<String> versions;
        try {
            InputStream index = this.downloadIndex();
            versions = this.indexParser.findVersions(index, artifactName);
        }
        catch (IOException e) {
            throw new NotFoundException("Failed to download chart versions for '" + this.name + "' account", (Throwable)e);
        }
        return versions;
    }

    private InputStream downloadIndex() throws IOException {
        try {
            ResponseBody indexDownloadResponse = this.fetchUrl(this.indexParser.indexPath());
            return indexDownloadResponse.byteStream();
        }
        catch (IOException e) {
            throw new FailedDownloadException("Failed to download index.yaml file in '" + this.indexParser.getRepository() + "' repository", e);
        }
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

