/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactProviderProperties;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactValidator;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.s3.enabled"})
@EnableConfigurationProperties(value={S3ArtifactProviderProperties.class})
class S3ArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ArtifactConfiguration.class);
    private final S3ArtifactProviderProperties s3ArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<S3ArtifactCredentials, S3ArtifactAccount> s3CredentialsProperties(Optional<S3ArtifactValidator> s3ArtifactValidator, S3ArtifactProviderProperties s3ArtifactProviderProperties) {
        return CredentialsTypeProperties.builder().type("artifacts-s3").credentialsClass(S3ArtifactCredentials.class).credentialsDefinitionClass(S3ArtifactAccount.class).defaultCredentialsSource(s3ArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new S3ArtifactCredentials((S3ArtifactAccount)a, s3ArtifactValidator, s3ArtifactProviderProperties);
            }
            catch (Exception e) {
                log.warn("Failure instantiating s3 artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public S3ArtifactConfiguration(S3ArtifactProviderProperties s3ArtifactProviderProperties) {
        this.s3ArtifactProviderProperties = s3ArtifactProviderProperties;
    }
}

