/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gcs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gcs.GcsArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class GcsArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GcsArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-gcs";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"gcs/object");
    @JsonIgnore
    private final Storage storage;

    GcsArtifactCredentials(String applicationName, GcsArtifactAccount account) throws IOException, GeneralSecurityException {
        GoogleCredentials credentials;
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
        Optional<String> credentialsPath = account.getJsonPath();
        if (credentialsPath.isPresent()) {
            FileInputStream stream = new FileInputStream(credentialsPath.get());
            credentials = GoogleCredentials.fromStream((InputStream)stream).createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.read_only"));
            log.info("Loaded credentials from {}", credentialsPath);
        } else {
            log.info("artifacts.gcs.enabled without artifacts.gcs.[].jsonPath. Using default application credentials.");
            credentials = GoogleCredentials.getApplicationDefault();
        }
        HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)credentials);
        this.name = account.getName();
        this.storage = new Storage.Builder((HttpTransport)transport, (JsonFactory)jsonFactory, (HttpRequestInitializer)requestInitializer).setApplicationName(applicationName).build();
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        int slash;
        String reference = artifact.getReference();
        Long generation = null;
        if (reference.startsWith("gs://")) {
            reference = reference.substring("gs://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("GCS references must be of the format gs://<bucket>/<file-path>, got: " + artifact);
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        int pound = path.lastIndexOf("#");
        if (pound >= 0) {
            generation = Long.valueOf(path.substring(pound + 1));
            path = path.substring(0, pound);
        }
        Storage.Objects.Get get = this.storage.objects().get(bucketName, path).setGeneration(generation);
        return get.executeMediaAsInputStream();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }
}

