/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitJobExecutor;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoArtifactProviderProperties;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoFileSystem;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.git-repo.enabled"})
@EnableConfigurationProperties(value={GitRepoArtifactProviderProperties.class})
class GitRepoArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitRepoArtifactConfiguration.class);
    private final GitRepoArtifactProviderProperties gitRepoArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<GitRepoArtifactCredentials, GitRepoArtifactAccount> gitCredentialsProperties(@Value(value="${artifacts.git-repo.git-executable:git}") String gitExecutable, JobExecutor jobExecutor, GitRepoFileSystem gitRepoFileSystem) {
        return CredentialsTypeProperties.builder().type("git/repo").credentialsClass(GitRepoArtifactCredentials.class).credentialsDefinitionClass(GitRepoArtifactAccount.class).defaultCredentialsSource(this.gitRepoArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new GitRepoArtifactCredentials(new GitJobExecutor((GitRepoArtifactAccount)a, jobExecutor, gitExecutable), gitRepoFileSystem);
            }
            catch (IOException e) {
                log.warn("Failure instantiating git artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Bean
    public GitRepoFileSystem gitRepoFileSystem() {
        return new GitRepoFileSystem(this.gitRepoArtifactProviderProperties);
    }

    @Generated
    public GitRepoArtifactConfiguration(GitRepoArtifactProviderProperties gitRepoArtifactProviderProperties) {
        this.gitRepoArtifactProviderProperties = gitRepoArtifactProviderProperties;
    }
}

