/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.google.common.hash.Hashing;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoArtifactProviderProperties;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class GitRepoFileSystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitRepoFileSystem.class);
    private static final Path CLONES_HOME = Paths.get(System.getProperty("java.io.tmpdir"), "gitrepos");
    private final GitRepoArtifactProviderProperties config;
    private final Map<String, Lock> pathLocks = new ConcurrentHashMap<String, Lock>();

    public GitRepoFileSystem(GitRepoArtifactProviderProperties properties) {
        this.config = properties;
    }

    public Path getLocalClonePath(String repoUrl, String branch) {
        return Paths.get(CLONES_HOME.toString(), this.hashCoordinates(repoUrl, branch));
    }

    public int getCloneWaitLockTimeoutSec() {
        return this.config.getCloneWaitLockTimeoutSec();
    }

    public boolean tryTimedLock(String repoUrl, String branch) throws InterruptedException {
        String hash = this.hashCoordinates(repoUrl, branch);
        log.debug("Trying filesystem timed lock for {} (branch {}), hash: {} for {} seconds", new Object[]{repoUrl, branch, hash, this.config.getCloneWaitLockTimeoutSec()});
        Lock lock = this.createOrGetLock(hash);
        boolean locked = lock.tryLock(this.config.getCloneWaitLockTimeoutSec(), TimeUnit.SECONDS);
        log.debug("Lock {} acquired for {} (branch {}), hash {}, lock instance: {}", new Object[]{locked ? "" : "NOT", repoUrl, branch, hash, lock});
        return locked;
    }

    private synchronized Lock createOrGetLock(String hash) {
        if (!this.pathLocks.containsKey(hash)) {
            log.debug("Creating new lock instance for hash: {}", (Object)hash);
            this.pathLocks.put(hash, new ReentrantLock());
        }
        return this.pathLocks.get(hash);
    }

    public boolean tryLock(String cloneHashDir) {
        log.debug("Trying filesystem lock for hash: {}", (Object)cloneHashDir);
        Lock lock = this.createOrGetLock(cloneHashDir);
        boolean locked = lock.tryLock();
        log.debug("Lock {} acquired for hash {}", (Object)(locked ? "" : "NOT"), (Object)cloneHashDir);
        return locked;
    }

    public void unlock(String repoUrl, String branch) {
        String hash = this.hashCoordinates(repoUrl, branch);
        log.debug("Unlocking filesystem for {} (branch {}), hash: {}", new Object[]{repoUrl, branch, hash});
        this.unlock(hash);
    }

    public synchronized void unlock(String cloneHashDir) {
        if (!this.pathLocks.containsKey(cloneHashDir)) {
            log.warn("Attempting to unlock filesystem with hash {} that doesn't have a lock", (Object)cloneHashDir);
            return;
        }
        Lock lock = this.pathLocks.get(cloneHashDir);
        log.debug("Unlocking filesystem for hash {}, lock instance: {}", (Object)cloneHashDir, (Object)lock);
        lock.unlock();
    }

    public boolean canRetainClone() {
        return this.config.getCloneRetentionMinutes() != 0 && this.hasFreeDisk();
    }

    private boolean hasFreeDisk() {
        long currentSize = 0L;
        if (CLONES_HOME.toFile().exists()) {
            currentSize = FileUtils.sizeOfDirectory((File)CLONES_HOME.toFile());
        }
        return currentSize >= 0L && currentSize < this.config.getCloneRetentionMaxBytes();
    }

    private String hashCoordinates(String repoUrl, String branch) {
        String coordinates = String.format("%s-%s", Optional.ofNullable(repoUrl).orElse("unknownUrl"), Optional.ofNullable(branch).orElse("defaultBranch"));
        return Hashing.sha256().hashString((CharSequence)coordinates, Charset.defaultCharset()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${artifacts.git-repo.clone-retention-check-ms:60000}")
    private void deleteExpiredRepos() {
        try {
            if (!CLONES_HOME.toFile().exists() || this.config.getCloneRetentionMinutes() < 0) {
                return;
            }
            File[] repos = CLONES_HOME.toFile().listFiles();
            if (repos == null) {
                return;
            }
            for (File r : repos) {
                long ageMin = (System.currentTimeMillis() - r.lastModified()) / 1000L / 60L;
                if (ageMin < (long)this.config.getCloneRetentionMinutes() || !this.tryLock(r.getName())) continue;
                try {
                    log.info("Deleting expired git clone {}", (Object)r.getName());
                    FileUtils.forceDelete((File)r);
                }
                finally {
                    this.unlock(r.getName());
                }
            }
        }
        catch (IOException e) {
            log.error("Error deleting expired git clones, ignoring", (Throwable)e);
        }
    }
}

