/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.maven;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;

@NonnullByDefault
public final class MavenArtifactCredentials
implements ArtifactCredentials {
    public static final String CREDENTIALS_TYPE = "artifacts-maven";
    private static final String RELEASE = "RELEASE";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String LATEST = "LATEST";
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    public static final ImmutableList<String> TYPES = ImmutableList.of((Object)"maven/file");
    private final MavenArtifactAccount account;
    private final OkHttpClient okHttpClient;
    private final RepositoryLayout repositoryLayout;
    private final ImmutableList<String> types = TYPES;

    public MavenArtifactCredentials(MavenArtifactAccount account, OkHttpClient okHttpClient) {
        this.account = account;
        this.okHttpClient = okHttpClient;
        try {
            RemoteRepository remoteRepository = new RemoteRepository.Builder(account.getName(), "default", account.getRepositoryUrl()).build();
            this.repositoryLayout = ((RepositoryLayoutProvider)MavenRepositorySystemUtils.newServiceLocator().addService(RepositoryLayoutProvider.class, DefaultRepositoryLayoutProvider.class).getService(RepositoryLayoutProvider.class)).newRepositoryLayout((RepositorySystemSession)MavenRepositorySystemUtils.newSession(), remoteRepository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this.account.getName();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    public InputStream download(com.netflix.spinnaker.kork.artifacts.model.Artifact artifact) {
        try {
            DefaultArtifact requestedArtifact = new DefaultArtifact(artifact.getReference());
            String artifactPath = this.resolveVersion((Artifact)requestedArtifact).map(version -> this.repositoryLayout.getLocation((Artifact)this.withVersion((Artifact)requestedArtifact, (String)version), false)).map(URI::getPath).orElseThrow(() -> new IllegalStateException("No versions matching constraint '" + artifact.getVersion() + "' for '" + artifact.getReference() + "'"));
            Request artifactRequest = new Request.Builder().url(this.account.getRepositoryUrl() + "/" + artifactPath).get().build();
            Response artifactResponse = this.okHttpClient.newCall(artifactRequest).execute();
            if (artifactResponse.isSuccessful()) {
                return artifactResponse.body().byteStream();
            }
            throw new IllegalStateException("Unable to download artifact with reference '" + artifact.getReference() + "'. HTTP " + artifactResponse.code());
        }
        catch (ArtifactDownloadException | IOException e) {
            throw new IllegalStateException("Unable to download artifact with reference '" + artifact.getReference() + "'", e);
        }
    }

    @Override
    public Optional<String> resolveArtifactName(com.netflix.spinnaker.kork.artifacts.model.Artifact artifact) {
        try {
            DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getReference());
            return Optional.of(aetherArtifact.getGroupId() + ":" + aetherArtifact.getArtifactId());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> resolveArtifactVersion(com.netflix.spinnaker.kork.artifacts.model.Artifact artifact) {
        try {
            return this.resolveVersion((Artifact)new DefaultArtifact(artifact.getReference()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Optional<String> resolveVersion(Artifact artifact) {
        try {
            String metadataPath = this.metadataUri(artifact).getPath();
            Request metadataRequest = new Request.Builder().url(this.account.getRepositoryUrl() + "/" + metadataPath).get().build();
            Response response = this.okHttpClient.newCall(metadataRequest).execute();
            if (response.isSuccessful()) {
                GenericVersionScheme versionScheme = new GenericVersionScheme();
                VersionConstraint versionConstraint = versionScheme.parseVersionConstraint(artifact.getVersion());
                Versioning versioning = new MetadataXpp3Reader().read(response.body().byteStream(), false).getVersioning();
                if (this.isRelease(artifact)) {
                    return Optional.ofNullable(versioning.getRelease());
                }
                if (this.isLatestSnapshot(artifact)) {
                    return this.resolveVersion((Artifact)this.withVersion(artifact, versioning.getLatest()));
                }
                if (this.isLatest(artifact)) {
                    String latestVersion = versioning.getLatest();
                    return latestVersion != null && latestVersion.endsWith("-SNAPSHOT") ? this.resolveVersion((Artifact)this.withVersion(artifact, latestVersion)) : Optional.ofNullable(latestVersion);
                }
                if (artifact.getVersion().endsWith("-SNAPSHOT")) {
                    String requestedClassifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
                    return versioning.getSnapshotVersions().stream().filter(v -> v.getClassifier().equals(requestedClassifier)).map(SnapshotVersion::getVersion).findFirst();
                }
                return versioning.getVersions().stream().map(arg_0 -> MavenArtifactCredentials.lambda$resolveVersion$3((VersionScheme)versionScheme, arg_0)).filter(arg_0 -> ((VersionConstraint)versionConstraint).containsVersion(arg_0)).max(Comparable::compareTo).map(Version::toString);
            }
            throw new IOException("Unsuccessful response retrieving maven-metadata.xml " + response.code());
        }
        catch (IOException | XmlPullParserException | InvalidVersionSpecificationException e) {
            throw new ArtifactDownloadException(e);
        }
    }

    private DefaultArtifact withVersion(Artifact artifact, String version) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), version);
    }

    private URI metadataUri(Artifact artifact) {
        String group = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        DefaultMetadata metadata = artifact.getVersion().endsWith("-SNAPSHOT") ? new DefaultMetadata(group, artifactId, version, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT) : (this.isRelease(artifact) ? new DefaultMetadata(group, artifactId, MAVEN_METADATA_XML, Metadata.Nature.RELEASE) : (this.isLatestSnapshot(artifact) ? new DefaultMetadata(group, artifactId, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT) : (this.isLatest(artifact) || version.startsWith("[") || version.startsWith("(") ? new DefaultMetadata(group, artifactId, MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT) : new DefaultMetadata(group, artifactId, MAVEN_METADATA_XML, Metadata.Nature.RELEASE))));
        return this.repositoryLayout.getLocation((Metadata)metadata, false);
    }

    private boolean isRelease(Artifact artifact) {
        return RELEASE.equals(artifact.getVersion()) || "latest.release".equals(artifact.getVersion());
    }

    private boolean isLatestSnapshot(Artifact artifact) {
        return SNAPSHOT.equals(artifact.getVersion()) || "latest.integration".equals(artifact.getVersion());
    }

    private boolean isLatest(Artifact artifact) {
        return LATEST.equals(artifact.getVersion());
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    private static /* synthetic */ Version lambda$resolveVersion$3(VersionScheme versionScheme, String v) {
        try {
            return versionScheme.parseVersion(v);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArtifactDownloadException(e);
        }
    }

    private static class ArtifactDownloadException
    extends RuntimeException {
        ArtifactDownloadException(Throwable cause) {
            super(cause);
        }
    }
}

