/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.oracle;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class OracleArtifactAccount
implements ArtifactAccount {
    private final String name;
    private final String namespace;
    private final String region;
    private final String userId;
    private final String fingerprint;
    private final String sshPrivateKeyFilePath;
    private final String privateKeyPassphrase;
    private final String tenancyId;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    OracleArtifactAccount(String name, String namespace, String region, String userId, String fingerprint, String sshPrivateKeyFilePath, String privateKeyPassphrase, String tenancyId) {
        this.name = Strings.nullToEmpty((String)name);
        this.namespace = Strings.nullToEmpty((String)namespace);
        this.region = Strings.nullToEmpty((String)region);
        this.userId = Strings.nullToEmpty((String)userId);
        this.fingerprint = Strings.nullToEmpty((String)fingerprint);
        this.sshPrivateKeyFilePath = Strings.nullToEmpty((String)sshPrivateKeyFilePath);
        this.privateKeyPassphrase = Strings.nullToEmpty((String)privateKeyPassphrase);
        this.tenancyId = Strings.nullToEmpty((String)tenancyId);
    }

    @Generated
    public static OracleArtifactAccountBuilder builder() {
        return new OracleArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public String getSshPrivateKeyFilePath() {
        return this.sshPrivateKeyFilePath;
    }

    @Generated
    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    @Generated
    public String getTenancyId() {
        return this.tenancyId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleArtifactAccount)) {
            return false;
        }
        OracleArtifactAccount other = (OracleArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        String other$sshPrivateKeyFilePath = other.getSshPrivateKeyFilePath();
        if (this$sshPrivateKeyFilePath == null ? other$sshPrivateKeyFilePath != null : !this$sshPrivateKeyFilePath.equals(other$sshPrivateKeyFilePath)) {
            return false;
        }
        String this$privateKeyPassphrase = this.getPrivateKeyPassphrase();
        String other$privateKeyPassphrase = other.getPrivateKeyPassphrase();
        if (this$privateKeyPassphrase == null ? other$privateKeyPassphrase != null : !this$privateKeyPassphrase.equals(other$privateKeyPassphrase)) {
            return false;
        }
        String this$tenancyId = this.getTenancyId();
        String other$tenancyId = other.getTenancyId();
        return !(this$tenancyId == null ? other$tenancyId != null : !this$tenancyId.equals(other$tenancyId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        result = result * 59 + ($sshPrivateKeyFilePath == null ? 43 : $sshPrivateKeyFilePath.hashCode());
        String $privateKeyPassphrase = this.getPrivateKeyPassphrase();
        result = result * 59 + ($privateKeyPassphrase == null ? 43 : $privateKeyPassphrase.hashCode());
        String $tenancyId = this.getTenancyId();
        result = result * 59 + ($tenancyId == null ? 43 : $tenancyId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OracleArtifactAccount(name=" + this.getName() + ", namespace=" + this.getNamespace() + ", region=" + this.getRegion() + ", userId=" + this.getUserId() + ", fingerprint=" + this.getFingerprint() + ", sshPrivateKeyFilePath=" + this.getSshPrivateKeyFilePath() + ", privateKeyPassphrase=" + this.getPrivateKeyPassphrase() + ", tenancyId=" + this.getTenancyId() + ")";
    }

    @Generated
    public static class OracleArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String namespace;
        @Generated
        private String region;
        @Generated
        private String userId;
        @Generated
        private String fingerprint;
        @Generated
        private String sshPrivateKeyFilePath;
        @Generated
        private String privateKeyPassphrase;
        @Generated
        private String tenancyId;

        @Generated
        OracleArtifactAccountBuilder() {
        }

        @Generated
        public OracleArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder region(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder sshPrivateKeyFilePath(String sshPrivateKeyFilePath) {
            this.sshPrivateKeyFilePath = sshPrivateKeyFilePath;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder privateKeyPassphrase(String privateKeyPassphrase) {
            this.privateKeyPassphrase = privateKeyPassphrase;
            return this;
        }

        @Generated
        public OracleArtifactAccountBuilder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            return this;
        }

        @Generated
        public OracleArtifactAccount build() {
            return new OracleArtifactAccount(this.name, this.namespace, this.region, this.userId, this.fingerprint, this.sshPrivateKeyFilePath, this.privateKeyPassphrase, this.tenancyId);
        }

        @Generated
        public String toString() {
            return "OracleArtifactAccount.OracleArtifactAccountBuilder(name=" + this.name + ", namespace=" + this.namespace + ", region=" + this.region + ", userId=" + this.userId + ", fingerprint=" + this.fingerprint + ", sshPrivateKeyFilePath=" + this.sshPrivateKeyFilePath + ", privateKeyPassphrase=" + this.privateKeyPassphrase + ", tenancyId=" + this.tenancyId + ")";
        }
    }
}

