/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.bitbucket;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.clouddriver.artifacts.config.TokenAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class BitbucketArtifactAccount
implements ArtifactAccount,
BasicAuth,
TokenAuth {
    private final String name;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Optional<String> usernamePasswordFile;
    private final Optional<String> token;
    private final Optional<String> tokenFile;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    BitbucketArtifactAccount(String name, String username, String password, String usernamePasswordFile, String token, String tokenFile) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password));
        this.usernamePasswordFile = Optional.ofNullable(Strings.emptyToNull((String)usernamePasswordFile));
        this.token = Optional.ofNullable(Strings.emptyToNull((String)token));
        this.tokenFile = Optional.ofNullable(Strings.emptyToNull((String)tokenFile));
    }

    @ParametersAreNullableByDefault
    BitbucketArtifactAccount(String name, String username, String password, String usernamePasswordFile) {
        this(name, username, password, usernamePasswordFile, null, null);
    }

    @Generated
    public static BitbucketArtifactAccountBuilder builder() {
        return new BitbucketArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Optional<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Optional<String> getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    @Override
    @Generated
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @Generated
    public Optional<String> getTokenFile() {
        return this.tokenFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitbucketArtifactAccount)) {
            return false;
        }
        BitbucketArtifactAccount other = (BitbucketArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<String> this$password = this.getPassword();
        Optional<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        Optional<String> this$usernamePasswordFile = this.getUsernamePasswordFile();
        Optional<String> other$usernamePasswordFile = other.getUsernamePasswordFile();
        if (this$usernamePasswordFile == null ? other$usernamePasswordFile != null : !((Object)this$usernamePasswordFile).equals(other$usernamePasswordFile)) {
            return false;
        }
        Optional<String> this$token = this.getToken();
        Optional<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Optional<String> this$tokenFile = this.getTokenFile();
        Optional<String> other$tokenFile = other.getTokenFile();
        return !(this$tokenFile == null ? other$tokenFile != null : !((Object)this$tokenFile).equals(other$tokenFile));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        Optional<String> $usernamePasswordFile = this.getUsernamePasswordFile();
        result = result * 59 + ($usernamePasswordFile == null ? 43 : ((Object)$usernamePasswordFile).hashCode());
        Optional<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Optional<String> $tokenFile = this.getTokenFile();
        result = result * 59 + ($tokenFile == null ? 43 : ((Object)$tokenFile).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BitbucketArtifactAccount(name=" + this.getName() + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", usernamePasswordFile=" + String.valueOf(this.getUsernamePasswordFile()) + ", token=" + String.valueOf(this.getToken()) + ", tokenFile=" + String.valueOf(this.getTokenFile()) + ")";
    }

    @Generated
    public static class BitbucketArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String usernamePasswordFile;
        @Generated
        private String token;
        @Generated
        private String tokenFile;

        @Generated
        BitbucketArtifactAccountBuilder() {
        }

        @Generated
        public BitbucketArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public BitbucketArtifactAccountBuilder tokenFile(String tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        @Generated
        public BitbucketArtifactAccount build() {
            return new BitbucketArtifactAccount(this.name, this.username, this.password, this.usernamePasswordFile, this.token, this.tokenFile);
        }

        @Generated
        public String toString() {
            return "BitbucketArtifactAccount.BitbucketArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ", token=" + this.token + ", tokenFile=" + this.tokenFile + ")";
        }
    }
}

