/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.TokenAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class GitRepoArtifactAccount
implements ArtifactAccount,
TokenAuth {
    private final String name;
    private final String username;
    private final String password;
    private final Optional<String> token;
    private final Optional<String> tokenFile;
    private final String sshPrivateKeyFilePath;
    private final String sshPrivateKeyPassphrase;
    private final String sshPrivateKeyPassphraseCmd;
    private final String sshKnownHostsFilePath;
    private final boolean sshTrustUnknownHosts;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    public GitRepoArtifactAccount(String name, String username, String password, String token, String tokenFile, String sshPrivateKeyFilePath, String sshPrivateKeyPassphrase, String sshPrivateKeyPassphraseCmd, String sshKnownHostsFilePath, boolean sshTrustUnknownHosts) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Strings.nullToEmpty((String)username);
        this.password = Strings.nullToEmpty((String)password);
        this.token = Optional.ofNullable(Strings.emptyToNull((String)token));
        this.tokenFile = Optional.ofNullable(Strings.emptyToNull((String)tokenFile));
        this.sshPrivateKeyFilePath = Strings.nullToEmpty((String)sshPrivateKeyFilePath);
        this.sshPrivateKeyPassphrase = Strings.nullToEmpty((String)sshPrivateKeyPassphrase);
        this.sshPrivateKeyPassphraseCmd = Strings.nullToEmpty((String)sshPrivateKeyPassphraseCmd);
        this.sshKnownHostsFilePath = Strings.nullToEmpty((String)sshKnownHostsFilePath);
        this.sshTrustUnknownHosts = sshTrustUnknownHosts;
    }

    @Generated
    public static GitRepoArtifactAccountBuilder builder() {
        return new GitRepoArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @Generated
    public Optional<String> getTokenFile() {
        return this.tokenFile;
    }

    @Generated
    public String getSshPrivateKeyFilePath() {
        return this.sshPrivateKeyFilePath;
    }

    @Generated
    public String getSshPrivateKeyPassphrase() {
        return this.sshPrivateKeyPassphrase;
    }

    @Generated
    public String getSshPrivateKeyPassphraseCmd() {
        return this.sshPrivateKeyPassphraseCmd;
    }

    @Generated
    public String getSshKnownHostsFilePath() {
        return this.sshKnownHostsFilePath;
    }

    @Generated
    public boolean isSshTrustUnknownHosts() {
        return this.sshTrustUnknownHosts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRepoArtifactAccount)) {
            return false;
        }
        GitRepoArtifactAccount other = (GitRepoArtifactAccount)o;
        if (this.isSshTrustUnknownHosts() != other.isSshTrustUnknownHosts()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Optional<String> this$token = this.getToken();
        Optional<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Optional<String> this$tokenFile = this.getTokenFile();
        Optional<String> other$tokenFile = other.getTokenFile();
        if (this$tokenFile == null ? other$tokenFile != null : !((Object)this$tokenFile).equals(other$tokenFile)) {
            return false;
        }
        String this$sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        String other$sshPrivateKeyFilePath = other.getSshPrivateKeyFilePath();
        if (this$sshPrivateKeyFilePath == null ? other$sshPrivateKeyFilePath != null : !this$sshPrivateKeyFilePath.equals(other$sshPrivateKeyFilePath)) {
            return false;
        }
        String this$sshPrivateKeyPassphrase = this.getSshPrivateKeyPassphrase();
        String other$sshPrivateKeyPassphrase = other.getSshPrivateKeyPassphrase();
        if (this$sshPrivateKeyPassphrase == null ? other$sshPrivateKeyPassphrase != null : !this$sshPrivateKeyPassphrase.equals(other$sshPrivateKeyPassphrase)) {
            return false;
        }
        String this$sshPrivateKeyPassphraseCmd = this.getSshPrivateKeyPassphraseCmd();
        String other$sshPrivateKeyPassphraseCmd = other.getSshPrivateKeyPassphraseCmd();
        if (this$sshPrivateKeyPassphraseCmd == null ? other$sshPrivateKeyPassphraseCmd != null : !this$sshPrivateKeyPassphraseCmd.equals(other$sshPrivateKeyPassphraseCmd)) {
            return false;
        }
        String this$sshKnownHostsFilePath = this.getSshKnownHostsFilePath();
        String other$sshKnownHostsFilePath = other.getSshKnownHostsFilePath();
        return !(this$sshKnownHostsFilePath == null ? other$sshKnownHostsFilePath != null : !this$sshKnownHostsFilePath.equals(other$sshKnownHostsFilePath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSshTrustUnknownHosts() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Optional<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Optional<String> $tokenFile = this.getTokenFile();
        result = result * 59 + ($tokenFile == null ? 43 : ((Object)$tokenFile).hashCode());
        String $sshPrivateKeyFilePath = this.getSshPrivateKeyFilePath();
        result = result * 59 + ($sshPrivateKeyFilePath == null ? 43 : $sshPrivateKeyFilePath.hashCode());
        String $sshPrivateKeyPassphrase = this.getSshPrivateKeyPassphrase();
        result = result * 59 + ($sshPrivateKeyPassphrase == null ? 43 : $sshPrivateKeyPassphrase.hashCode());
        String $sshPrivateKeyPassphraseCmd = this.getSshPrivateKeyPassphraseCmd();
        result = result * 59 + ($sshPrivateKeyPassphraseCmd == null ? 43 : $sshPrivateKeyPassphraseCmd.hashCode());
        String $sshKnownHostsFilePath = this.getSshKnownHostsFilePath();
        result = result * 59 + ($sshKnownHostsFilePath == null ? 43 : $sshKnownHostsFilePath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitRepoArtifactAccount(name=" + this.getName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + String.valueOf(this.getToken()) + ", tokenFile=" + String.valueOf(this.getTokenFile()) + ", sshPrivateKeyFilePath=" + this.getSshPrivateKeyFilePath() + ", sshPrivateKeyPassphrase=" + this.getSshPrivateKeyPassphrase() + ", sshPrivateKeyPassphraseCmd=" + this.getSshPrivateKeyPassphraseCmd() + ", sshKnownHostsFilePath=" + this.getSshKnownHostsFilePath() + ", sshTrustUnknownHosts=" + this.isSshTrustUnknownHosts() + ")";
    }

    @Generated
    public static class GitRepoArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String token;
        @Generated
        private String tokenFile;
        @Generated
        private String sshPrivateKeyFilePath;
        @Generated
        private String sshPrivateKeyPassphrase;
        @Generated
        private String sshPrivateKeyPassphraseCmd;
        @Generated
        private String sshKnownHostsFilePath;
        @Generated
        private boolean sshTrustUnknownHosts;

        @Generated
        GitRepoArtifactAccountBuilder() {
        }

        @Generated
        public GitRepoArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder tokenFile(String tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder sshPrivateKeyFilePath(String sshPrivateKeyFilePath) {
            this.sshPrivateKeyFilePath = sshPrivateKeyFilePath;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder sshPrivateKeyPassphrase(String sshPrivateKeyPassphrase) {
            this.sshPrivateKeyPassphrase = sshPrivateKeyPassphrase;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder sshPrivateKeyPassphraseCmd(String sshPrivateKeyPassphraseCmd) {
            this.sshPrivateKeyPassphraseCmd = sshPrivateKeyPassphraseCmd;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder sshKnownHostsFilePath(String sshKnownHostsFilePath) {
            this.sshKnownHostsFilePath = sshKnownHostsFilePath;
            return this;
        }

        @Generated
        public GitRepoArtifactAccountBuilder sshTrustUnknownHosts(boolean sshTrustUnknownHosts) {
            this.sshTrustUnknownHosts = sshTrustUnknownHosts;
            return this;
        }

        @Generated
        public GitRepoArtifactAccount build() {
            return new GitRepoArtifactAccount(this.name, this.username, this.password, this.token, this.tokenFile, this.sshPrivateKeyFilePath, this.sshPrivateKeyPassphrase, this.sshPrivateKeyPassphraseCmd, this.sshKnownHostsFilePath, this.sshTrustUnknownHosts);
        }

        @Generated
        public String toString() {
            return "GitRepoArtifactAccount.GitRepoArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", token=" + this.token + ", tokenFile=" + this.tokenFile + ", sshPrivateKeyFilePath=" + this.sshPrivateKeyFilePath + ", sshPrivateKeyPassphrase=" + this.sshPrivateKeyPassphrase + ", sshPrivateKeyPassphraseCmd=" + this.sshPrivateKeyPassphraseCmd + ", sshKnownHostsFilePath=" + this.sshKnownHostsFilePath + ", sshTrustUnknownHosts=" + this.sshTrustUnknownHosts + ")";
        }
    }
}

