/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitRepo;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitJobExecutor;
import com.netflix.spinnaker.clouddriver.artifacts.gitRepo.GitRepoFileSystem;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class GitRepoArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitRepoArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "git/repo";
    private static final Pattern GENERIC_URL_PATTERN = Pattern.compile("^.*/(.*)$");
    private final ImmutableList<String> types = ImmutableList.of((Object)"git/repo");
    private final String name;
    private final GitJobExecutor executor;
    private final GitRepoFileSystem gitRepoFileSystem;

    public GitRepoArtifactCredentials(GitJobExecutor executor, GitRepoFileSystem gitRepoFileSystem) {
        this.executor = executor;
        this.gitRepoFileSystem = gitRepoFileSystem;
        this.name = this.executor.getAccount().getName();
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    @Override
    public InputStream download(Artifact artifact) throws IOException {
        String repoUrl = artifact.getReference();
        String subPath = this.artifactSubPath(artifact);
        String branch = this.artifactVersion(artifact);
        Path stagingPath = this.gitRepoFileSystem.getLocalClonePath(repoUrl, branch);
        String repoBasename = this.getRepoBasename(repoUrl);
        Path outputFile = Paths.get(stagingPath.toString(), repoBasename + ".tgz");
        try {
            return this.getLockedInputStream(repoUrl, subPath, branch, stagingPath, repoBasename, outputFile);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting to acquire file system lock for " + repoUrl + " (branch " + branch + ").", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileInputStream getLockedInputStream(String repoUrl, String subPath, String branch, Path stagingPath, String repoBasename, Path outputFile) throws InterruptedException, IOException {
        if (this.gitRepoFileSystem.tryTimedLock(repoUrl, branch)) {
            try {
                FileInputStream fileInputStream = this.getInputStream(repoUrl, subPath, branch, stagingPath, repoBasename, outputFile);
                return fileInputStream;
            }
            finally {
                if (!this.gitRepoFileSystem.canRetainClone()) {
                    log.debug("Deleting clone for {} (branch {})", (Object)repoUrl, (Object)branch);
                    FileUtils.deleteDirectory((File)stagingPath.toFile());
                }
                this.gitRepoFileSystem.unlock(repoUrl, branch);
            }
        }
        throw new IOException("Timeout waiting to acquire file system lock for " + repoUrl + " (branch " + branch + "). Waited " + this.gitRepoFileSystem.getCloneWaitLockTimeoutSec() + " seconds.");
    }

    @NotNull
    private FileInputStream getInputStream(String repoUrl, String subPath, String branch, Path stagingPath, String repoBasename, Path outputFile) throws IOException {
        this.executor.cloneOrPull(repoUrl, branch, stagingPath, repoBasename);
        log.info("Creating archive for git/repo {}", (Object)repoUrl);
        this.executor.archive(Paths.get(stagingPath.toString(), repoBasename), branch, subPath, outputFile);
        return new FileInputStream(outputFile.toFile());
    }

    private String getRepoBasename(String url) {
        Matcher matcher = GENERIC_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Git repo url " + url + " doesn't match regex " + String.valueOf(GENERIC_URL_PATTERN));
        }
        return matcher.group(1).replaceAll("\\.git$", "");
    }

    private String artifactSubPath(Artifact artifact) {
        if (!Strings.nullToEmpty((String)artifact.getLocation()).isEmpty()) {
            return artifact.getLocation();
        }
        return Strings.nullToEmpty((String)((String)artifact.getMetadata("subPath")));
    }

    private String artifactVersion(Artifact artifact) {
        return !Strings.isNullOrEmpty((String)artifact.getVersion()) ? artifact.getVersion() : "master";
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

