/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.github;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.clouddriver.artifacts.config.TokenAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class GitHubArtifactAccount
implements ArtifactAccount,
BasicAuth,
TokenAuth {
    private final String name;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Optional<String> usernamePasswordFile;
    private final Optional<String> token;
    private final Optional<String> tokenFile;
    private final String githubAPIVersion;
    private final boolean useContentAPI;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    GitHubArtifactAccount(String name, String username, String password, String usernamePasswordFile, String token, String tokenFile, String githubAPIVersion, boolean useContentAPI) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password));
        this.usernamePasswordFile = Optional.ofNullable(Strings.emptyToNull((String)usernamePasswordFile));
        this.token = Optional.ofNullable(Strings.emptyToNull((String)token));
        this.tokenFile = Optional.ofNullable(Strings.emptyToNull((String)tokenFile));
        this.githubAPIVersion = StringUtils.defaultString((String)githubAPIVersion, (String)"v3");
        this.useContentAPI = useContentAPI;
    }

    @Generated
    public static GitHubArtifactAccountBuilder builder() {
        return new GitHubArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Optional<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Optional<String> getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    @Override
    @Generated
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @Generated
    public Optional<String> getTokenFile() {
        return this.tokenFile;
    }

    @Generated
    public String getGithubAPIVersion() {
        return this.githubAPIVersion;
    }

    @Generated
    public boolean isUseContentAPI() {
        return this.useContentAPI;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitHubArtifactAccount)) {
            return false;
        }
        GitHubArtifactAccount other = (GitHubArtifactAccount)o;
        if (this.isUseContentAPI() != other.isUseContentAPI()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<String> this$password = this.getPassword();
        Optional<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        Optional<String> this$usernamePasswordFile = this.getUsernamePasswordFile();
        Optional<String> other$usernamePasswordFile = other.getUsernamePasswordFile();
        if (this$usernamePasswordFile == null ? other$usernamePasswordFile != null : !((Object)this$usernamePasswordFile).equals(other$usernamePasswordFile)) {
            return false;
        }
        Optional<String> this$token = this.getToken();
        Optional<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Optional<String> this$tokenFile = this.getTokenFile();
        Optional<String> other$tokenFile = other.getTokenFile();
        if (this$tokenFile == null ? other$tokenFile != null : !((Object)this$tokenFile).equals(other$tokenFile)) {
            return false;
        }
        String this$githubAPIVersion = this.getGithubAPIVersion();
        String other$githubAPIVersion = other.getGithubAPIVersion();
        return !(this$githubAPIVersion == null ? other$githubAPIVersion != null : !this$githubAPIVersion.equals(other$githubAPIVersion));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseContentAPI() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        Optional<String> $usernamePasswordFile = this.getUsernamePasswordFile();
        result = result * 59 + ($usernamePasswordFile == null ? 43 : ((Object)$usernamePasswordFile).hashCode());
        Optional<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Optional<String> $tokenFile = this.getTokenFile();
        result = result * 59 + ($tokenFile == null ? 43 : ((Object)$tokenFile).hashCode());
        String $githubAPIVersion = this.getGithubAPIVersion();
        result = result * 59 + ($githubAPIVersion == null ? 43 : $githubAPIVersion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitHubArtifactAccount(name=" + this.getName() + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", usernamePasswordFile=" + String.valueOf(this.getUsernamePasswordFile()) + ", token=" + String.valueOf(this.getToken()) + ", tokenFile=" + String.valueOf(this.getTokenFile()) + ", githubAPIVersion=" + this.getGithubAPIVersion() + ", useContentAPI=" + this.isUseContentAPI() + ")";
    }

    @Generated
    public static class GitHubArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String usernamePasswordFile;
        @Generated
        private String token;
        @Generated
        private String tokenFile;
        @Generated
        private String githubAPIVersion;
        @Generated
        private boolean useContentAPI;

        @Generated
        GitHubArtifactAccountBuilder() {
        }

        @Generated
        public GitHubArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder tokenFile(String tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder githubAPIVersion(String githubAPIVersion) {
            this.githubAPIVersion = githubAPIVersion;
            return this;
        }

        @Generated
        public GitHubArtifactAccountBuilder useContentAPI(boolean useContentAPI) {
            this.useContentAPI = useContentAPI;
            return this;
        }

        @Generated
        public GitHubArtifactAccount build() {
            return new GitHubArtifactAccount(this.name, this.username, this.password, this.usernamePasswordFile, this.token, this.tokenFile, this.githubAPIVersion, this.useContentAPI);
        }

        @Generated
        public String toString() {
            return "GitHubArtifactAccount.GitHubArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ", token=" + this.token + ", tokenFile=" + this.tokenFile + ", githubAPIVersion=" + this.githubAPIVersion + ", useContentAPI=" + this.useContentAPI + ")";
        }
    }
}

