/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.gitlab;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.TokenAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class GitlabArtifactAccount
implements ArtifactAccount,
TokenAuth {
    private final String name;
    private final Optional<String> token;
    private final Optional<String> tokenFile;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    GitlabArtifactAccount(String name, String token, String tokenFile) {
        this.name = Strings.nullToEmpty((String)name);
        this.token = Optional.ofNullable(Strings.emptyToNull((String)token));
        this.tokenFile = Optional.ofNullable(Strings.emptyToNull((String)tokenFile));
    }

    @Generated
    public static GitlabArtifactAccountBuilder builder() {
        return new GitlabArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @Generated
    public Optional<String> getTokenFile() {
        return this.tokenFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitlabArtifactAccount)) {
            return false;
        }
        GitlabArtifactAccount other = (GitlabArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$token = this.getToken();
        Optional<String> other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Optional<String> this$tokenFile = this.getTokenFile();
        Optional<String> other$tokenFile = other.getTokenFile();
        return !(this$tokenFile == null ? other$tokenFile != null : !((Object)this$tokenFile).equals(other$tokenFile));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Optional<String> $tokenFile = this.getTokenFile();
        result = result * 59 + ($tokenFile == null ? 43 : ((Object)$tokenFile).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitlabArtifactAccount(name=" + this.getName() + ", token=" + String.valueOf(this.getToken()) + ", tokenFile=" + String.valueOf(this.getTokenFile()) + ")";
    }

    @Generated
    public static class GitlabArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String token;
        @Generated
        private String tokenFile;

        @Generated
        GitlabArtifactAccountBuilder() {
        }

        @Generated
        public GitlabArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public GitlabArtifactAccountBuilder token(String token) {
            this.token = token;
            return this;
        }

        @Generated
        public GitlabArtifactAccountBuilder tokenFile(String tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        @Generated
        public GitlabArtifactAccount build() {
            return new GitlabArtifactAccount(this.name, this.token, this.tokenFile);
        }

        @Generated
        public String toString() {
            return "GitlabArtifactAccount.GitlabArtifactAccountBuilder(name=" + this.name + ", token=" + this.token + ", tokenFile=" + this.tokenFile + ")";
        }
    }
}

