/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.helm;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.config.BasicAuth;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.springframework.boot.context.properties.ConstructorBinding;

@NonnullByDefault
public final class HelmArtifactAccount
implements ArtifactAccount,
BasicAuth {
    private final String name;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Optional<String> usernamePasswordFile;
    private final String repository;

    @ConstructorBinding
    @ParametersAreNullableByDefault
    public HelmArtifactAccount(String name, String username, String password, String usernamePasswordFile, String repository) {
        this.name = Strings.nullToEmpty((String)name);
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password));
        this.usernamePasswordFile = Optional.ofNullable(Strings.emptyToNull((String)usernamePasswordFile));
        this.repository = Strings.nullToEmpty((String)repository);
    }

    @Generated
    public static HelmArtifactAccountBuilder builder() {
        return new HelmArtifactAccountBuilder();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Optional<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Optional<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Optional<String> getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmArtifactAccount)) {
            return false;
        }
        HelmArtifactAccount other = (HelmArtifactAccount)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        Optional<String> this$password = this.getPassword();
        Optional<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        Optional<String> this$usernamePasswordFile = this.getUsernamePasswordFile();
        Optional<String> other$usernamePasswordFile = other.getUsernamePasswordFile();
        if (this$usernamePasswordFile == null ? other$usernamePasswordFile != null : !((Object)this$usernamePasswordFile).equals(other$usernamePasswordFile)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        Optional<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        Optional<String> $usernamePasswordFile = this.getUsernamePasswordFile();
        result = result * 59 + ($usernamePasswordFile == null ? 43 : ((Object)$usernamePasswordFile).hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HelmArtifactAccount(name=" + this.getName() + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", usernamePasswordFile=" + String.valueOf(this.getUsernamePasswordFile()) + ", repository=" + this.getRepository() + ")";
    }

    @Generated
    public static class HelmArtifactAccountBuilder {
        @Generated
        private String name;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String usernamePasswordFile;
        @Generated
        private String repository;

        @Generated
        HelmArtifactAccountBuilder() {
        }

        @Generated
        public HelmArtifactAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HelmArtifactAccountBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public HelmArtifactAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public HelmArtifactAccountBuilder usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return this;
        }

        @Generated
        public HelmArtifactAccountBuilder repository(String repository) {
            this.repository = repository;
            return this;
        }

        @Generated
        public HelmArtifactAccount build() {
            return new HelmArtifactAccount(this.name, this.username, this.password, this.usernamePasswordFile, this.repository);
        }

        @Generated
        public String toString() {
            return "HelmArtifactAccount.HelmArtifactAccountBuilder(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ", repository=" + this.repository + ")";
        }
    }
}

