/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.http;

import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.http.HttpArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import java.util.List;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.http.enabled"})
@EnableConfigurationProperties(value={HttpArtifactProviderProperties.class})
class HttpArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpArtifactConfiguration.class);
    private final HttpArtifactProviderProperties httpArtifactProviderProperties;
    private final HttpArtifactAccount noAuthAccount = HttpArtifactAccount.builder().name("no-auth-http-account").build();

    @Bean
    public CredentialsTypeProperties<HttpArtifactCredentials, HttpArtifactAccount> httpCredentialsProperties(OkHttpClient okHttpClient) {
        return CredentialsTypeProperties.builder().type("artifacts-http").credentialsClass(HttpArtifactCredentials.class).credentialsDefinitionClass(HttpArtifactAccount.class).defaultCredentialsSource(this::getHttpAccounts).credentialsParser(a -> {
            try {
                return new HttpArtifactCredentials((HttpArtifactAccount)a, okHttpClient);
            }
            catch (Exception e) {
                log.warn("Failure instantiating Http artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    private List<HttpArtifactAccount> getHttpAccounts() {
        List<HttpArtifactAccount> accounts = this.httpArtifactProviderProperties.getAccounts();
        if (accounts.stream().noneMatch(HttpArtifactAccount::usesAuth)) {
            accounts.add(this.noAuthAccount);
        }
        return accounts;
    }

    @Generated
    public HttpArtifactConfiguration(HttpArtifactProviderProperties httpArtifactProviderProperties) {
        this.httpArtifactProviderProperties = httpArtifactProviderProperties;
    }
}

