/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;

final class DiskFreeingInputStream
extends InputStream {
    private final InputStream delegate;
    private final Path deleteOnClose;

    public DiskFreeingInputStream(InputStream delegate, Path deleteOnClose) {
        this.delegate = delegate;
        this.deleteOnClose = deleteOnClose;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (Files.exists(this.deleteOnClose, new LinkOption[0])) {
            Files.walk(this.deleteOnClose, new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
        }
    }
}

