/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.ivy;

import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.ivy.IvyArtifactProviderProperties;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"artifacts.ivy.enabled"})
@EnableConfigurationProperties(value={IvyArtifactProviderProperties.class})
class IvyArtifactConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IvyArtifactConfiguration.class);
    private final IvyArtifactProviderProperties ivyArtifactProviderProperties;

    @Bean
    public CredentialsTypeProperties<IvyArtifactCredentials, IvyArtifactAccount> ivyCredentialsProperties() {
        return CredentialsTypeProperties.builder().type("artifacts-ivy").credentialsClass(IvyArtifactCredentials.class).credentialsDefinitionClass(IvyArtifactAccount.class).defaultCredentialsSource(this.ivyArtifactProviderProperties::getAccounts).credentialsParser(a -> {
            try {
                return new IvyArtifactCredentials((IvyArtifactAccount)a);
            }
            catch (Exception e) {
                log.warn("Failure instantiating ivy artifact account {}: ", (Object)a, (Object)e);
                return null;
            }
        }).build();
    }

    @Generated
    public IvyArtifactConfiguration(IvyArtifactProviderProperties ivyArtifactProviderProperties) {
        this.ivyArtifactProviderProperties = ivyArtifactProviderProperties;
    }
}

