/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.artifacts.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.collect.ImmutableList;
import com.netflix.spectator.aws.SpectatorRequestMetricCollector;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactAccount;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactProviderProperties;
import com.netflix.spinnaker.clouddriver.artifacts.s3.S3ArtifactValidator;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public class S3ArtifactCredentials
implements ArtifactCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ArtifactCredentials.class);
    public static final String CREDENTIALS_TYPE = "artifacts-s3";
    private final String name;
    private final ImmutableList<String> types = ImmutableList.of((Object)"s3/object");
    private final String apiEndpoint;
    private final String apiRegion;
    private final String region;
    private final String awsAccessKeyId;
    private final String awsSecretAccessKey;
    private final String signerOverride;
    private final Optional<S3ArtifactValidator> s3ArtifactValidator;
    private final S3ArtifactProviderProperties s3ArtifactProviderProperties;
    private final S3ArtifactRequestHandler s3ArtifactRequestHandler;
    private AmazonS3 amazonS3;

    S3ArtifactCredentials(S3ArtifactAccount account, Optional<S3ArtifactValidator> s3ArtifactValidator, S3ArtifactProviderProperties s3ArtifactProviderProperties) {
        this(account, s3ArtifactValidator, null, s3ArtifactProviderProperties);
    }

    S3ArtifactCredentials(S3ArtifactAccount account, @Nullable AmazonS3 amazonS3, S3ArtifactProviderProperties s3ArtifactProviderProperties) {
        this(account, Optional.empty(), amazonS3, s3ArtifactProviderProperties);
    }

    S3ArtifactCredentials(S3ArtifactAccount account, Optional<S3ArtifactValidator> s3ArtifactValidator, @Nullable AmazonS3 amazonS3, S3ArtifactProviderProperties s3ArtifactProviderProperties) throws IllegalArgumentException {
        this.name = account.getName();
        this.apiEndpoint = account.getApiEndpoint();
        this.apiRegion = account.getApiRegion();
        this.region = account.getRegion();
        this.awsAccessKeyId = account.getAwsAccessKeyId();
        this.awsSecretAccessKey = account.getAwsSecretAccessKey();
        this.signerOverride = account.getSignerOverride();
        this.s3ArtifactValidator = s3ArtifactValidator;
        this.amazonS3 = amazonS3;
        this.s3ArtifactProviderProperties = s3ArtifactProviderProperties;
        this.s3ArtifactRequestHandler = new S3ArtifactRequestHandler(this.name);
    }

    private AmazonS3 getS3Client() {
        if (this.amazonS3 != null) {
            return this.amazonS3;
        }
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.setClientConfiguration(this.getClientConfiguration());
        builder.setRequestHandlers(new RequestHandler2[]{this.s3ArtifactRequestHandler});
        if (!this.apiEndpoint.isEmpty()) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(this.apiEndpoint, this.apiRegion);
            builder.setEndpointConfiguration(endpoint);
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        } else if (!this.region.isEmpty()) {
            builder.setRegion(this.region);
        }
        if (!this.awsAccessKeyId.isEmpty() && !this.awsSecretAccessKey.isEmpty()) {
            BasicAWSCredentials awsStaticCreds = new BasicAWSCredentials(this.awsAccessKeyId, this.awsSecretAccessKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsStaticCreds));
        }
        this.amazonS3 = (AmazonS3)builder.build();
        return this.amazonS3;
    }

    @Override
    public InputStream download(Artifact artifact) throws IllegalArgumentException {
        S3Object s3obj;
        int slash;
        String reference = artifact.getReference();
        if (reference.startsWith("s3://")) {
            reference = reference.substring("s3://".length());
        }
        if ((slash = reference.indexOf("/")) <= 0) {
            throw new IllegalArgumentException("S3 references must be of the format s3://<bucket>/<file-path>, got: " + String.valueOf(artifact));
        }
        String bucketName = reference.substring(0, slash);
        String path = reference.substring(slash + 1);
        try {
            s3obj = this.getS3Client().getObject(bucketName, path);
        }
        catch (AmazonS3Exception e) {
            log.error("exception getting object: s3://{}/{}: '{}'", new Object[]{bucketName, path, e.getMessage()});
            if ("NoSuchKey".equals(e.getErrorCode())) {
                throw new NotFoundException("s3://" + bucketName + "/" + path + " not found", (Throwable)e);
            }
            throw e;
        }
        if (this.s3ArtifactValidator.isEmpty()) {
            return s3obj.getObjectContent();
        }
        return this.s3ArtifactValidator.get().validate(this.getS3Client(), s3obj);
    }

    public String getType() {
        return CREDENTIALS_TYPE;
    }

    private ClientConfiguration getClientConfiguration() {
        ClientConfiguration configuration = PredefinedClientConfigurations.defaultConfig();
        if (!this.signerOverride.isEmpty()) {
            configuration.setSignerOverride(this.signerOverride);
        }
        if (this.s3ArtifactProviderProperties.getClientExecutionTimeout() != null) {
            configuration.setClientExecutionTimeout(this.s3ArtifactProviderProperties.getClientExecutionTimeout().intValue());
        }
        if (this.s3ArtifactProviderProperties.getConnectionMaxIdleMillis() != null) {
            configuration.setConnectionMaxIdleMillis(this.s3ArtifactProviderProperties.getConnectionMaxIdleMillis().longValue());
        }
        if (this.s3ArtifactProviderProperties.getConnectionTimeout() != null) {
            configuration.setConnectionTimeout(this.s3ArtifactProviderProperties.getConnectionTimeout().intValue());
        }
        if (this.s3ArtifactProviderProperties.getConnectionTTL() != null) {
            configuration.setConnectionTTL(this.s3ArtifactProviderProperties.getConnectionTTL().longValue());
        }
        if (this.s3ArtifactProviderProperties.getMaxConnections() != null) {
            configuration.setMaxConnections(this.s3ArtifactProviderProperties.getMaxConnections().intValue());
        }
        if (this.s3ArtifactProviderProperties.getRequestTimeout() != null) {
            configuration.setRequestTimeout(this.s3ArtifactProviderProperties.getRequestTimeout().intValue());
        }
        if (this.s3ArtifactProviderProperties.getSocketTimeout() != null) {
            configuration.setSocketTimeout(this.s3ArtifactProviderProperties.getSocketTimeout().intValue());
        }
        if (this.s3ArtifactProviderProperties.getValidateAfterInactivityMillis() != null) {
            configuration.setValidateAfterInactivityMillis(this.s3ArtifactProviderProperties.getValidateAfterInactivityMillis().intValue());
        }
        return configuration;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    @NonnullByDefault
    static class S3ArtifactRequestHandler
    extends RequestHandler2 {
        private final String value;

        S3ArtifactRequestHandler(String value) {
            this.value = value;
        }

        public void beforeRequest(Request<?> request) {
            request.addHandlerContext(SpectatorRequestMetricCollector.DEFAULT_HANDLER_CONTEXT_KEY, (Object)this.value);
        }
    }
}

