/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.controllers;

import com.netflix.spinnaker.clouddriver.aws.model.Role;
import com.netflix.spinnaker.clouddriver.aws.model.RoleProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roles"})
public class RoleController {
    @Autowired(required=false)
    List<RoleProvider> roleProviders;

    @RequestMapping(method={RequestMethod.GET}, value={"/{cloudProvider}"})
    Collection<Role> getRoles(@PathVariable String cloudProvider) {
        if (this.roleProviders == null) {
            return Collections.emptyList();
        }
        Set<Role> roles = this.roleProviders.stream().filter(roleProvider -> roleProvider.getCloudProvider().equals(cloudProvider)).flatMap(roleProvider -> roleProvider.getAll().stream()).collect(Collectors.toSet());
        return roles;
    }
}

