/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.config.AwsConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class InstanceTypeUtils {
    private static final String PARAVIRTUAL = "paravirtual";
    private static final Set<String> PARAVIRTUAL_FAMILIES = ImmutableSet.of((Object)"c1", (Object)"c3", (Object)"hi1", (Object)"hs1", (Object)"m1", (Object)"m2", (Object[])new String[]{"m3", "t1"});
    private static final Set<String> DEFAULT_EBS_OPTIMIZED_FAMILIES = ImmutableSet.of((Object)"a1", (Object)"c4", (Object)"c5", (Object)"d2", (Object)"f1", (Object)"g3", (Object[])new String[]{"i3", "m4", "m5", "p2", "p3", "r4", "r5", "x1", "t3"});
    private static final Set<String> BURSTABLE_PERFORMANCE_FAMILIES = ImmutableSet.of((Object)"t2", (Object)"t3", (Object)"t3a", (Object)"t4g");

    public static void validateCompatibility(String virtualizationType, Set<String> instanceTypes) {
        instanceTypes.forEach(instanceType -> {
            String family = InstanceTypeUtils.getInstanceFamily(instanceType);
            if (PARAVIRTUAL.equals(virtualizationType) && !PARAVIRTUAL_FAMILIES.contains(family)) {
                throw new IllegalArgumentException("Instance type " + instanceType + " does not support virtualization type " + virtualizationType + ". Please select a different image or instance type.");
            }
        });
    }

    public static boolean getDefaultEbsOptimizedFlag(String instanceType) {
        return DEFAULT_EBS_OPTIMIZED_FAMILIES.contains(InstanceTypeUtils.getInstanceFamily(instanceType));
    }

    public static boolean isBurstingSupported(String instanceType) {
        return BURSTABLE_PERFORMANCE_FAMILIES.contains(InstanceTypeUtils.getInstanceFamily(instanceType));
    }

    public static boolean isBurstingSupportedByAllTypes(Set<String> instanceTypes) {
        for (String type : instanceTypes) {
            if (InstanceTypeUtils.isBurstingSupported(type)) continue;
            return false;
        }
        return true;
    }

    private static String getInstanceFamily(String instanceType) {
        if (instanceType != null && instanceType.contains(".")) {
            return instanceType.split("\\.")[0];
        }
        return "";
    }

    public static class BlockDeviceConfig {
        private final AwsConfiguration.DeployDefaults deployDefaults;
        private final Map<String, List<AmazonBlockDevice>> blockDevicesByInstanceType;

        public BlockDeviceConfig(AwsConfiguration.DeployDefaults deployDefaults) {
            this.deployDefaults = deployDefaults;
            this.blockDevicesByInstanceType = ImmutableMap.builder().put((Object)"a1.medium", this.sizedBlockDevicesForEbs(40)).put((Object)"a1.large", this.sizedBlockDevicesForEbs(40)).put((Object)"a1.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"a1.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"a1.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"a1.metal", this.sizedBlockDevicesForEbs(120)).put((Object)"c1.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c1.xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"c3.large", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c3.xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c3.2xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c3.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c3.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c4.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c4.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c4.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c4.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c4.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c5.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5.9xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5.18xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5d.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5d.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5d.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5d.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5d.9xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5d.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5d.18xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5d.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"c5d.metal", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"c5n.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c5n.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5n.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5n.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5n.9xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5n.18xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5n.metal", this.sizedBlockDevicesForEbs(120)).put((Object)"c5a.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c5a.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5a.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c5a.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5a.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5a.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5a.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5a.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c5ad.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5ad.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5ad.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c5ad.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5ad.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5ad.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5ad.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c5ad.24xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c6g.medium", this.sizedBlockDevicesForEbs(40)).put((Object)"c6g.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c6g.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c6g.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c6g.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6g.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6g.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6g.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6g.metal", this.sizedBlockDevicesForEbs(120)).put((Object)"c6gd.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"c6gd.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c6gd.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c6gd.metal", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"c6gn.medium", this.sizedBlockDevicesForEbs(40)).put((Object)"c6gn.large", this.sizedBlockDevicesForEbs(40)).put((Object)"c6gn.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c6gn.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"c6gn.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6gn.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6gn.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"c6gn.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"cc2.8xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"cg1.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"cr1.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"d2.xlarge", this.enumeratedBlockDevicesWithVirtualName(3)).put((Object)"d2.2xlarge", this.enumeratedBlockDevicesWithVirtualName(6)).put((Object)"d2.4xlarge", this.enumeratedBlockDevicesWithVirtualName(12)).put((Object)"d2.8xlarge", this.enumeratedBlockDevicesWithVirtualName(24)).put((Object)"d3.xlarge", this.enumeratedBlockDevicesWithVirtualName(3)).put((Object)"d3.2xlarge", this.enumeratedBlockDevicesWithVirtualName(6)).put((Object)"d3.4xlarge", this.enumeratedBlockDevicesWithVirtualName(12)).put((Object)"d3.8xlarge", this.enumeratedBlockDevicesWithVirtualName(24)).put((Object)"d3en.xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"d3en.2xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"d3en.4xlarge", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"d3en.6xlarge", this.enumeratedBlockDevicesWithVirtualName(12)).put((Object)"d3en.8xlarge", this.enumeratedBlockDevicesWithVirtualName(16)).put((Object)"d3en.12xlarge", this.enumeratedBlockDevicesWithVirtualName(24)).put((Object)"f1.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"f1.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"f1.16xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"g2.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g2.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"g3s.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"g3.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"g3.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"g3.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"g4ad.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4ad.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4ad.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"g4dn.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.12xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.16xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"g4dn.metal", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"h1.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"h1.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"h1.8xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"h1.16xlarge", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"hs1.8xlarge", this.enumeratedBlockDevicesWithVirtualName(24)).put((Object)"i2.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i2.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i2.2xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"i2.4xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"i2.8xlarge", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"i3.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"i3.8xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"i3.16xlarge", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"i3.metal", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"i3en.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3en.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3en.2xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"i3en.3xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"i3en.6xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"i3en.12xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"i3en.24xlarge", this.enumeratedBlockDevicesWithVirtualName(8)).put((Object)"inf1.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"inf1.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"inf1.6xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"inf1.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m1.small", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m1.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m1.large", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m1.xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m2.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m2.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m2.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m3.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m3.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m3.xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m3.2xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m4.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m4.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m4.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m4.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m4.10xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m4.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m5.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5d.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5d.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5d.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5d.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5d.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5d.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5d.16xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m5d.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m5n.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m5n.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5n.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5n.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5n.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5n.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5n.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5n.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5dn.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5dn.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5dn.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5dn.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5dn.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5dn.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5dn.16xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m5dn.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m5a.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m5a.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5a.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5a.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5a.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5a.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5a.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5a.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5ad.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5ad.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5ad.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m5ad.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5ad.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5ad.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5ad.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m5ad.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"m5zn.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m5zn.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5zn.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m5zn.3xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5zn.6xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m5zn.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m6g.medium", this.sizedBlockDevicesForEbs(40)).put((Object)"m6g.large", this.sizedBlockDevicesForEbs(40)).put((Object)"m6g.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m6g.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"m6g.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m6g.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m6g.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m6g.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"m6g.metal", this.sizedBlockDevicesForEbs(120)).put((Object)"m6gd.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"m6gd.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m6gd.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"m6gd.metal", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r3.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r3.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r3.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r3.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r3.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r4.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r4.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r4.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r4.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r4.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r4.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r5.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5d.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5d.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5d.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5d.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5d.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5d.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5d.16xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"r5d.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"r5n.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r5n.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5n.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5n.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5n.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5n.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5n.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5n.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5dn.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5dn.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5dn.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5dn.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5dn.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5dn.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5dn.16xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"r5dn.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"r5a.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r5a.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5a.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5a.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5a.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5a.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5a.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5a.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5ad.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5ad.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5ad.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r5ad.4xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5ad.8xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5ad.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5ad.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r5ad.24xlarge", this.enumeratedBlockDevicesWithVirtualName(4)).put((Object)"r5b.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r5b.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5b.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r5b.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5b.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5b.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5b.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r5b.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r6g.medium", this.sizedBlockDevicesForEbs(40)).put((Object)"r6g.large", this.sizedBlockDevicesForEbs(40)).put((Object)"r6g.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r6g.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"r6g.4xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r6g.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r6g.12xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r6g.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"r6g.metal", this.sizedBlockDevicesForEbs(120)).put((Object)"r6gd.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"r6gd.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r6gd.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"r6gd.metal", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"p2.xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"p2.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"p2.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"p3.2xlarge", this.sizedBlockDevicesForEbs(80)).put((Object)"p3.8xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"p3.16xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"p3dn.24xlarge", this.sizedBlockDevicesForEbs(120)).put((Object)"p4d.24xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"t1.micro", Collections.emptyList()).put((Object)"t2.nano", Collections.emptyList()).put((Object)"t2.micro", Collections.emptyList()).put((Object)"t2.small", Collections.emptyList()).put((Object)"t2.medium", Collections.emptyList()).put((Object)"t2.large", Collections.emptyList()).put((Object)"t2.xlarge", Collections.emptyList()).put((Object)"t2.2xlarge", Collections.emptyList()).put((Object)"t3.nano", Collections.emptyList()).put((Object)"t3.micro", Collections.emptyList()).put((Object)"t3.small", Collections.emptyList()).put((Object)"t3.medium", Collections.emptyList()).put((Object)"t3.large", Collections.emptyList()).put((Object)"t3.xlarge", Collections.emptyList()).put((Object)"t3.2xlarge", Collections.emptyList()).put((Object)"t3a.nano", Collections.emptyList()).put((Object)"t3a.micro", Collections.emptyList()).put((Object)"t3a.small", Collections.emptyList()).put((Object)"t3a.medium", Collections.emptyList()).put((Object)"t3a.large", Collections.emptyList()).put((Object)"t3a.xlarge", Collections.emptyList()).put((Object)"t3a.2xlarge", Collections.emptyList()).put((Object)"t4g.nano", Collections.emptyList()).put((Object)"t4g.micro", Collections.emptyList()).put((Object)"t4g.small", Collections.emptyList()).put((Object)"t4g.medium", Collections.emptyList()).put((Object)"t4g.large", Collections.emptyList()).put((Object)"t4g.xlarge", Collections.emptyList()).put((Object)"t4g.2xlarge", Collections.emptyList()).put((Object)"x1.16xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1.32xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"x1e.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1e.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1e.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1e.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1e.16xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x1e.32xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"x2gd.medium", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.4xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.8xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"x2gd.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"x2gd.16xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).put((Object)"z1d.large", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"z1d.xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"z1d.2xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"z1d.3xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"z1d.6xlarge", this.enumeratedBlockDevicesWithVirtualName(1)).put((Object)"z1d.12xlarge", this.enumeratedBlockDevicesWithVirtualName(2)).build();
        }

        public List<AmazonBlockDevice> getBlockDevicesForInstanceType(String instanceType) {
            List<AmazonBlockDevice> blockDevices = this.blockDevicesByInstanceType.get(instanceType);
            if (blockDevices == null && this.deployDefaults.getUnknownInstanceTypeBlockDevice() != null) {
                return ImmutableList.of((Object)this.deployDefaults.getUnknownInstanceTypeBlockDevice());
            }
            return blockDevices;
        }

        public Set<String> getInstanceTypesWithBlockDeviceMappings() {
            return this.blockDevicesByInstanceType.keySet();
        }

        private List<AmazonBlockDevice> enumeratedBlockDevicesWithVirtualName(int size) {
            char[] letters = "abcdefghijklmnopqrstuvwxyz".toCharArray();
            return (List)IntStream.range(0, size).mapToObj(i -> new AmazonBlockDevice.Builder().deviceName("/dev/sd" + letters[i + 1]).virtualName("ephemeral" + i).build()).collect(ImmutableList.toImmutableList());
        }

        private List<AmazonBlockDevice> defaultBlockDevicesForEbsOnly() {
            return ImmutableList.of((Object)new AmazonBlockDevice.Builder().deviceName("/dev/sdb").size(125).volumeType(this.deployDefaults.getDefaultBlockDeviceType()).build(), (Object)new AmazonBlockDevice.Builder().deviceName("/dev/sdc").size(125).volumeType(this.deployDefaults.getDefaultBlockDeviceType()).build());
        }

        private List<AmazonBlockDevice> sizedBlockDevicesForEbs(int capacity) {
            return ImmutableList.of((Object)new AmazonBlockDevice.Builder().deviceName("/dev/sdb").size(capacity).volumeType(this.deployDefaults.getDefaultBlockDeviceType()).build());
        }
    }
}

