/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmiIdResolver;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ResolvedAmiResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.LoadBalancerLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.TargetGroupLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.scalingpolicy.ScalingPolicyCopier;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonAsgLifecycleHook;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.events.CreateServerGroupEvent;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAmazonDeployHandler
implements DeployHandler<BasicAmazonDeployDescription>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    private static final String SUBNET_ID_OVERRIDE_TAG = "SPINNAKER_SUBNET_ID_OVERRIDE";
    private final RegionScopedProviderFactory regionScopedProviderFactory;
    private final CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository;
    private final AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider;
    private final AwsConfiguration.DeployDefaults deployDefaults;
    private final ScalingPolicyCopier scalingPolicyCopier;
    private final InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig;
    private final DynamicConfigService dynamicConfigService;
    private List<CreateServerGroupEvent> deployEvents;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public BasicAmazonDeployHandler(RegionScopedProviderFactory regionScopedProviderFactory, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository, AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider, AwsConfiguration.DeployDefaults deployDefaults, ScalingPolicyCopier scalingPolicyCopier, InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig, DynamicConfigService dynamicConfigService) {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        this.deployEvents = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        RegionScopedProviderFactory regionScopedProviderFactory2 = regionScopedProviderFactory;
        this.regionScopedProviderFactory = (RegionScopedProviderFactory)ScriptBytecodeAdapter.castToType((Object)regionScopedProviderFactory2, RegionScopedProviderFactory.class);
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository = accountCredentialsRepository;
        this.accountCredentialsRepository = (CredentialsRepository)ScriptBytecodeAdapter.castToType(credentialsRepository, CredentialsRepository.class);
        AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider2 = amazonServerGroupProvider;
        this.amazonServerGroupProvider = (AwsConfiguration.AmazonServerGroupProvider)ScriptBytecodeAdapter.castToType((Object)amazonServerGroupProvider2, AwsConfiguration.AmazonServerGroupProvider.class);
        AwsConfiguration.DeployDefaults deployDefaults2 = deployDefaults;
        this.deployDefaults = (AwsConfiguration.DeployDefaults)ScriptBytecodeAdapter.castToType((Object)deployDefaults2, AwsConfiguration.DeployDefaults.class);
        ScalingPolicyCopier scalingPolicyCopier2 = scalingPolicyCopier;
        this.scalingPolicyCopier = (ScalingPolicyCopier)ScriptBytecodeAdapter.castToType((Object)scalingPolicyCopier2, ScalingPolicyCopier.class);
        InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig2 = blockDeviceConfig;
        this.blockDeviceConfig = (InstanceTypeUtils.BlockDeviceConfig)ScriptBytecodeAdapter.castToType((Object)blockDeviceConfig2, InstanceTypeUtils.BlockDeviceConfig.class);
        DynamicConfigService dynamicConfigService2 = dynamicConfigService;
        this.dynamicConfigService = (DynamicConfigService)ScriptBytecodeAdapter.castToType((Object)dynamicConfigService2, DynamicConfigService.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public boolean handles(DeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return description instanceof BasicAmazonDeployDescription;
    }

    public DeploymentResult handle(BasicAmazonDeployDescription description, List priorOutputs) {
        Reference description2 = new Reference((Object)description);
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object deploymentResult = callSiteArray[2].callConstructor(DeploymentResult.class);
        callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[5].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"Preparing deployment to ", "..."}));
        Map.Entry entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), Iterator.class);
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            Reference region = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[8].callGetProperty((Object)entry)));
            Object sourceRegionScopedProvider = callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].callGroovyObjectGetProperty((Object)this), callSiteArray[11].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            Object object3 = callSiteArray[12].callCurrent((GroovyObject)this, sourceRegionScopedProvider, callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[15].callGetProperty(callSiteArray[16].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)((BasicAmazonDeployDescription)description2.get()));
            description2.set((Object)((BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)object3, BasicAmazonDeployDescription.class)));
            List availabilityZones = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callGetProperty((Object)entry), List.class);
            Object subnetType = callSiteArray[18].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            public final class _handle_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _handle_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                    return it instanceof UpsertAmazonLoadBalancerResult;
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_handle_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _handle_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            List suppliedLoadBalancers = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callSafe(callSiteArray[20].callGetPropertySafe(callSiteArray[21].call((Object)priorOutputs, (Object)new _handle_closure1(this, this))), (Object)((String)region.get())), List.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"loadBalancers");
            }
            callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), DefaultTypeTransformation.booleanUnbox((Object)(object2 = callSiteArray[25].callGetPropertySafe((Object)suppliedLoadBalancers))) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            Object regionScopedProvider = callSiteArray[26].call((Object)this.regionScopedProviderFactory, callSiteArray[27].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)((String)region.get()));
            Object loadBalancers = callSiteArray[28].call(callSiteArray[29].callCurrent((GroovyObject)this), regionScopedProvider, callSiteArray[30].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGetProperty(loadBalancers))) {
                throw (Throwable)callSiteArray[32].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[33].callGetProperty(loadBalancers)}, new String[]{"Unable to find classic load balancers named ", ""}));
            }
            Object targetGroups = callSiteArray[34].call(callSiteArray[35].callCurrent((GroovyObject)this), regionScopedProvider, callSiteArray[36].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callGetProperty(targetGroups))) {
                throw (Throwable)callSiteArray[38].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[39].callGetProperty(targetGroups)}, new String[]{"Unable to find target groups named ", ""}));
            }
            Object amazonEC2 = callSiteArray[40].callGetProperty(regionScopedProvider);
            String classicLinkVpcId = null;
            List classicLinkVpcSecurityGroups = null;
            if (!DefaultTypeTransformation.booleanUnbox((Object)subnetType)) {
                Object result = callSiteArray[41].call(amazonEC2);
                public final class _handle_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _handle_closure2(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                        return callSiteArray[0].callGetProperty(it);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "classicLinkEnabled";
                        return new CallSiteArray(_handle_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _handle_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object4 = callSiteArray[42].callGetPropertySafe(callSiteArray[43].call(callSiteArray[44].callGetProperty(result), (Object)new _handle_closure2(this, this)));
                classicLinkVpcId = ShortTypeHandling.castToString((Object)object4);
                if (DefaultTypeTransformation.booleanUnbox((Object)classicLinkVpcId)) {
                    Set classicLinkGroupNames = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
                    Object object5 = callSiteArray[46].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
                    callSiteArray[45].call((Object)classicLinkGroupNames, DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                        callSiteArray[48].call((Object)classicLinkGroupNames, callSiteArray[49].callGroovyObjectGetProperty((Object)this.deployDefaults));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                        public final class _handle_closure3
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _handle_closure3(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                return callSiteArray[0].call(it, ScriptBytecodeAdapter.bitwiseNegate((Object)"sg-[0-9a-f]+"));
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "matches";
                                return new CallSiteArray(_handle_closure3.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _handle_closure3.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        Object object6 = callSiteArray[52].call((Object)classicLinkGroupNames, (Object)new _handle_closure3(this, this));
                        Reference groupIds = new Reference(DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        callSiteArray[53].call((Object)classicLinkGroupNames, groupIds.get());
                        if (DefaultTypeTransformation.booleanUnbox((Object)groupIds.get())) {
                            Object describeSG = callSiteArray[54].call(callSiteArray[55].callConstructor(DescribeSecurityGroupsRequest.class), groupIds.get());
                            Object object7 = sourceRegionScopedProvider;
                            Object provider = DefaultTypeTransformation.booleanUnbox((Object)object7) ? object7 : regionScopedProvider;
                            public final class _handle_closure4
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference description;
                                private /* synthetic */ Reference groupIds;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _handle_closure4(Object _outerInstance, Object _thisObject, Reference description, Reference groupIds) {
                                    Reference reference;
                                    Reference reference2;
                                    CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.description = reference2 = description;
                                    this.groupIds = reference = groupIds;
                                }

                                public Object doCall(Object it) {
                                    CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.description.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(this.groupIds.get(), callSiteArray[3].callGetProperty(it)))) {
                                        return callSiteArray[4].callGetProperty(it);
                                    }
                                    return null;
                                }

                                @Generated
                                public BasicAmazonDeployDescription getDescription() {
                                    CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                    return (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BasicAmazonDeployDescription.class);
                                }

                                @Generated
                                public Object getGroupIds() {
                                    CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                    return this.groupIds.get();
                                }

                                @Generated
                                public Object doCall() {
                                    CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _handle_closure4.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "vpcId";
                                    stringArray[1] = "classicLinkVpcId";
                                    stringArray[2] = "contains";
                                    stringArray[3] = "groupId";
                                    stringArray[4] = "groupName";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[5];
                                    _handle_closure4.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_handle_closure4.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _handle_closure4.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            Object object8 = callSiteArray[56].call(callSiteArray[57].callGetProperty(callSiteArray[58].call(callSiteArray[59].callGetProperty(provider), describeSG)), (Object)new _handle_closure4(this, this, description2, groupIds));
                            Object resolvedNames = DefaultTypeTransformation.booleanUnbox((Object)object8) ? object8 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[60].call(resolvedNames), (Object)callSiteArray[61].call(groupIds.get()))) {
                                throw (Throwable)callSiteArray[62].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{groupIds.get(), resolvedNames}, new String[]{"failed to look up classic link security groups, had ", " found ", ""}));
                            }
                            callSiteArray[63].call((Object)classicLinkGroupNames, resolvedNames);
                        }
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                            Object srcName = callSiteArray[66].call(Names.class, callSiteArray[67].callGetProperty(callSiteArray[68].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))));
                            boolean mismatch = false;
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[69].callGetProperty(srcName), (Object)callSiteArray[70].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                                boolean bl;
                                callSiteArray[71].call((Object)classicLinkGroupNames, callSiteArray[72].callGetProperty(srcName));
                                mismatch = bl = true;
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGetProperty(srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[74].callGetProperty(srcName), (Object)callSiteArray[75].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                                boolean bl;
                                callSiteArray[76].call((Object)classicLinkGroupNames, callSiteArray[77].call((Object)new GStringImpl(new Object[]{callSiteArray[78].callGetProperty(srcName), callSiteArray[79].callGetProperty(srcName)}, new String[]{"", "-", ""})));
                                mismatch = bl = true;
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callGetProperty(srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[81].callGetProperty(srcName), (Object)callSiteArray[82].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                                Object object9;
                                callSiteArray[83].call((Object)classicLinkGroupNames, (Object)new GStringImpl(new Object[]{callSiteArray[84].callGetProperty(srcName), DefaultTypeTransformation.booleanUnbox((Object)(object9 = callSiteArray[85].callGetProperty(srcName))) ? object9 : "", callSiteArray[86].callGetProperty(srcName)}, new String[]{"", "-", "-", ""}));
                            }
                        }
                        List groupNamesToLookUp = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)classicLinkGroupNames, callSiteArray[88].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                            callSiteArray[89].call((Object)groupNamesToLookUp, callSiteArray[90].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                            String stackGroup = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[92].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[93].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"", "-", ""}));
                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].call((Object)classicLinkGroupNames, (Object)stackGroup))) {
                                callSiteArray[95].call((Object)groupNamesToLookUp, (Object)stackGroup);
                            }
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                            Object object10;
                            String clusterGroup = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[97].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), DefaultTypeTransformation.booleanUnbox((Object)(object10 = callSiteArray[98].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) ? object10 : "", callSiteArray[99].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"", "-", "-", ""}));
                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].call((Object)classicLinkGroupNames, (Object)clusterGroup))) {
                                callSiteArray[101].call((Object)groupNamesToLookUp, (Object)clusterGroup);
                            }
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)groupNamesToLookUp) && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[102].call((Object)classicLinkGroupNames), (Object)callSiteArray[103].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                            Object appGroups = callSiteArray[104].call(callSiteArray[105].callGetProperty(regionScopedProvider), (Object)groupNamesToLookUp, (Object)classicLinkVpcId, (Object)false);
                            String name = null;
                            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].call((Object)groupNamesToLookUp), Iterator.class);
                            while (iterator2.hasNext()) {
                                name = ShortTypeHandling.castToString(iterator2.next());
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].call(appGroups, (Object)name))) continue;
                                if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[108].call((Object)classicLinkGroupNames), (Object)callSiteArray[109].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                                    callSiteArray[110].call((Object)classicLinkGroupNames, (Object)name);
                                    continue;
                                }
                                callSiteArray[111].call(callSiteArray[112].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{name, callSiteArray[113].callGroovyObjectGetProperty((Object)this.deployDefaults)}, new String[]{"Not adding ", " to classicLinkVpcSecurityGroups, already have ", " groups"}));
                            }
                        }
                    }
                    Object object11 = callSiteArray[114].call((Object)classicLinkGroupNames);
                    classicLinkVpcSecurityGroups = (List)ScriptBytecodeAdapter.castToType((Object)object11, List.class);
                    callSiteArray[115].call(callSiteArray[116].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{classicLinkGroupNames}, new String[]{"Attaching ", " as classicLinkVpcSecurityGroups"}));
                }
            }
            public final class _handle_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference description;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _handle_closure5(Object _outerInstance, Object _thisObject, Reference region, Reference description) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.region = reference2 = region;
                    this.description = reference = description;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return it instanceof ResolvedAmiResult && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.region.get()) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)callSiteArray[2].callGroovyObjectGetProperty(this.description.get())) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)callSiteArray[4].callGroovyObjectGetProperty(this.description.get())));
                    }
                    return it instanceof ResolvedAmiResult && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty(it), (Object)this.region.get()) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty(it), (Object)callSiteArray[7].callGroovyObjectGetProperty(this.description.get())) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty(it), (Object)callSiteArray[9].callGroovyObjectGetProperty(this.description.get())));
                }

                @Generated
                public String getRegion() {
                    CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public BasicAmazonDeployDescription getDescription() {
                    CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                    return (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BasicAmazonDeployDescription.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "region";
                    stringArray[1] = "amiName";
                    stringArray[2] = "amiName";
                    stringArray[3] = "amiId";
                    stringArray[4] = "amiName";
                    stringArray[5] = "region";
                    stringArray[6] = "amiName";
                    stringArray[7] = "amiName";
                    stringArray[8] = "amiId";
                    stringArray[9] = "amiName";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[10];
                    _handle_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_handle_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _handle_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            ResolvedAmiResult ami = (ResolvedAmiResult)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[117].call((Object)priorOutputs, (Object)new _handle_closure5(this, this, region, description2)))) ? object : callSiteArray[118].call(AmiIdResolver.class, amazonEC2, (Object)((String)region.get()), callSiteArray[119].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[120].callGetProperty(callSiteArray[121].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))), ResolvedAmiResult.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)ami)) {
                throw (Throwable)callSiteArray[122].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[123].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (String)region.get()}, new String[]{"unable to resolve AMI imageId from ", " in ", ""}));
            }
            callSiteArray[124].call(InstanceTypeUtils.class, callSiteArray[125].callGroovyObjectGetProperty((Object)ami), callSiteArray[126].call((Object)((BasicAmazonDeployDescription)description2.get())));
            Object account = callSiteArray[127].call(this.accountCredentialsRepository, callSiteArray[128].callGetProperty(callSiteArray[129].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))));
            if (ScriptBytecodeAdapter.compareEqual((Object)account, null)) {
                throw (Throwable)callSiteArray[130].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[131].callGetProperty(callSiteArray[132].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))}, new String[]{"Account with name ", " could not be found."}));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[133].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                Object object12 = callSiteArray[134].call(AsgConfigHelper.class, callSiteArray[135].callGroovyObjectGetProperty((Object)ami));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object12, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[136].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null)) {
                Object object13 = callSiteArray[137].call((Object)this.blockDeviceConfig, callSiteArray[138].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object13, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[139].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)"")) {
                Object var51_51 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var51_51, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"spotPrice");
            }
            Object[] objectArray = new Object[6];
            objectArray[0] = "min";
            Object object14 = callSiteArray[141].callGetProperty(callSiteArray[142].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object14) ? object14 : Integer.valueOf(0);
            objectArray[2] = "max";
            Object object15 = callSiteArray[143].callGetProperty(callSiteArray[144].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object15) ? object15 : Integer.valueOf(0);
            objectArray[4] = "desired";
            Object object16 = callSiteArray[145].callGetProperty(callSiteArray[146].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray[5] = DefaultTypeTransformation.booleanUnbox((Object)object16) ? object16 : Integer.valueOf(0);
            Object capacity = callSiteArray[140].callConstructor(DeploymentResult.Deployment.Capacity.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
            Object autoScalingWorker = callSiteArray[147].callConstructor(AutoScalingWorker.class, regionScopedProvider, (Object)this.dynamicConfigService);
            Object[] objectArray2 = new Object[112];
            objectArray2[0] = "application";
            objectArray2[1] = callSiteArray[149].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[2] = "region";
            objectArray2[3] = (String)region.get();
            objectArray2[4] = "credentials";
            objectArray2[5] = callSiteArray[150].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[6] = "stack";
            objectArray2[7] = callSiteArray[151].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[8] = "freeFormDetails";
            objectArray2[9] = callSiteArray[152].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[10] = "ami";
            objectArray2[11] = callSiteArray[153].callGroovyObjectGetProperty((Object)ami);
            objectArray2[12] = "classicLinkVpcId";
            objectArray2[13] = classicLinkVpcId;
            objectArray2[14] = "classicLinkVpcSecurityGroups";
            objectArray2[15] = classicLinkVpcSecurityGroups;
            objectArray2[16] = "minInstances";
            objectArray2[17] = callSiteArray[154].callGetProperty(capacity);
            objectArray2[18] = "maxInstances";
            objectArray2[19] = callSiteArray[155].callGetProperty(capacity);
            objectArray2[20] = "desiredInstances";
            objectArray2[21] = callSiteArray[156].callGetProperty(capacity);
            objectArray2[22] = "securityGroups";
            objectArray2[23] = callSiteArray[157].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[24] = "iamRole";
            objectArray2[25] = callSiteArray[158].callStatic(BasicAmazonDeployHandler.class, (Object)((BasicAmazonDeployDescription)description2.get()), (Object)this.deployDefaults);
            objectArray2[26] = "keyPair";
            Object object17 = callSiteArray[159].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[27] = DefaultTypeTransformation.booleanUnbox((Object)object17) ? object17 : callSiteArray[160].callGetPropertySafe(account);
            objectArray2[28] = "sequence";
            objectArray2[29] = callSiteArray[161].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[30] = "ignoreSequence";
            objectArray2[31] = callSiteArray[162].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[32] = "startDisabled";
            objectArray2[33] = callSiteArray[163].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[34] = "associatePublicIpAddress";
            objectArray2[35] = callSiteArray[164].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[36] = "blockDevices";
            objectArray2[37] = callSiteArray[165].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[38] = "instanceType";
            objectArray2[39] = callSiteArray[166].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[40] = "availabilityZones";
            objectArray2[41] = availabilityZones;
            objectArray2[42] = "subnetType";
            objectArray2[43] = subnetType;
            objectArray2[44] = "subnetIds";
            objectArray2[45] = callSiteArray[167].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[46] = "classicLoadBalancers";
            objectArray2[47] = callSiteArray[168].callGetProperty(loadBalancers);
            objectArray2[48] = "targetGroupArns";
            objectArray2[49] = callSiteArray[169].callGetProperty(targetGroups);
            objectArray2[50] = "cooldown";
            objectArray2[51] = callSiteArray[170].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[52] = "enabledMetrics";
            objectArray2[53] = callSiteArray[171].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[54] = "healthCheckGracePeriod";
            objectArray2[55] = callSiteArray[172].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[56] = "healthCheckType";
            objectArray2[57] = callSiteArray[173].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[58] = "terminationPolicies";
            objectArray2[59] = callSiteArray[174].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[60] = "spotMaxPrice";
            objectArray2[61] = callSiteArray[175].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[62] = "suspendedProcesses";
            objectArray2[63] = callSiteArray[176].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[64] = "kernelId";
            objectArray2[65] = callSiteArray[177].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[66] = "ramdiskId";
            objectArray2[67] = callSiteArray[178].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[68] = "instanceMonitoring";
            objectArray2[69] = callSiteArray[179].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[70] = "ebsOptimized";
            objectArray2[71] = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[180].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null) ? callSiteArray[181].call(InstanceTypeUtils.class, callSiteArray[182].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) : callSiteArray[183].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[72] = "base64UserData";
            objectArray2[73] = callSiteArray[184].callSafe(callSiteArray[185].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray2[74] = "legacyUdf";
            objectArray2[75] = callSiteArray[186].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[76] = "userDataOverride";
            objectArray2[77] = callSiteArray[187].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[78] = "tags";
            objectArray2[79] = callSiteArray[188].callGetProperty(callSiteArray[189].callStatic(BasicAmazonDeployHandler.class, (Object)this.deployDefaults, (Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray2[80] = "blockDeviceTags";
            objectArray2[81] = callSiteArray[190].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[82] = "lifecycleHooks";
            objectArray2[83] = callSiteArray[191].callStatic(BasicAmazonDeployHandler.class, account, (Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[84] = "setLaunchTemplate";
            objectArray2[85] = callSiteArray[192].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[86] = "requireIMDSv2";
            objectArray2[87] = callSiteArray[193].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[88] = "enableEnclave";
            objectArray2[89] = callSiteArray[194].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[90] = "associateIPv6Address";
            objectArray2[91] = callSiteArray[195].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[92] = "unlimitedCpuCredits";
            objectArray2[93] = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[196].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null) ? callSiteArray[197].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())) : callSiteArray[198].callStatic(BasicAmazonDeployHandler.class, callSiteArray[199].call((Object)((BasicAmazonDeployDescription)description2.get())));
            objectArray2[94] = "placement";
            objectArray2[95] = callSiteArray[200].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[96] = "licenseSpecifications";
            objectArray2[97] = callSiteArray[201].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[98] = "onDemandAllocationStrategy";
            objectArray2[99] = callSiteArray[202].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[100] = "onDemandBaseCapacity";
            objectArray2[101] = callSiteArray[203].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[102] = "onDemandPercentageAboveBaseCapacity";
            objectArray2[103] = callSiteArray[204].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[104] = "spotAllocationStrategy";
            objectArray2[105] = callSiteArray[205].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[106] = "spotInstancePools";
            objectArray2[107] = callSiteArray[206].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[108] = "launchTemplateOverridesForInstanceType";
            objectArray2[109] = callSiteArray[207].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            objectArray2[110] = "capacityRebalance";
            objectArray2[111] = callSiteArray[208].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
            Object asgConfig = callSiteArray[148].callConstructor(AutoScalingWorker.AsgConfiguration.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray2));
            Object asgName = callSiteArray[209].call(autoScalingWorker, asgConfig);
            callSiteArray[210].call(callSiteArray[211].callGetProperty(deploymentResult), callSiteArray[212].call((Object)new GStringImpl(new Object[]{(String)region.get(), asgName}, new String[]{"", ":", ""})));
            Object object18 = asgName;
            callSiteArray[213].call(callSiteArray[214].callGetProperty(deploymentResult), (Object)((String)region.get()), object18);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[215].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
                callSiteArray[216].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[217].callGroovyObjectGetProperty((Object)this), (Object)sourceRegionScopedProvider, (Object)callSiteArray[218].callGetProperty(sourceRegionScopedProvider), (Object)callSiteArray[219].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)callSiteArray[220].callGetProperty(callSiteArray[221].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)asgName, (Object)callSiteArray[222].callGetProperty(callSiteArray[223].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)((String)region.get())));
            }
            callSiteArray[224].call(callSiteArray[225].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[226].callConstructor(CreateServerGroupEvent.class, callSiteArray[227].callGetProperty(AmazonCloudProvider.class), callSiteArray[228].callGetProperty(account), (Object)((String)region.get()), asgName));
            callSiteArray[229].call(callSiteArray[230].callGetProperty(deploymentResult), callSiteArray[231].callConstructor(DeploymentResult.Deployment.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"cloudProvider", "aws", "account", callSiteArray[232].call((Object)((BasicAmazonDeployDescription)description2.get())), "location", (String)region.get(), "serverGroupName", asgName, "capacity", capacity})));
        }
        callSiteArray[233].call(callSiteArray[234].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[235].callGetProperty(deploymentResult)}, new String[]{"Created the following deployments: ", ""}));
        return (DeploymentResult)ScriptBytecodeAdapter.castToType((Object)deploymentResult, DeploymentResult.class);
    }

    @VisibleForTesting
    LoadBalancerLookupHelper loadBalancerLookupHelper() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (LoadBalancerLookupHelper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[236].callConstructor(LoadBalancerLookupHelper.class), LoadBalancerLookupHelper.class);
    }

    @VisibleForTesting
    TargetGroupLookupHelper targetGroupLookupHelper() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (TargetGroupLookupHelper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[237].callConstructor(TargetGroupLookupHelper.class), TargetGroupLookupHelper.class);
    }

    @VisibleForTesting
    BasicAmazonDeployDescription copySourceAttributes(RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, String sourceAsgName, Boolean useSourceCapacity, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Boolean copySourceSubnetIdOverrides = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[238].callGroovyObjectGetProperty((Object)description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[239].callGroovyObjectGetProperty((Object)description));
        if (DefaultTypeTransformation.booleanUnbox((Object)copySourceSubnetIdOverrides) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider) && DefaultTypeTransformation.booleanUnbox((Object)sourceAsgName)) {
            Object serverGroup = callSiteArray[240].call((Object)this.amazonServerGroupProvider, callSiteArray[241].callGetPropertySafe(callSiteArray[242].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider)), callSiteArray[243].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider), (Object)sourceAsgName);
            if (DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
                public final class _copySourceAttributes_closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _copySourceAttributes_closure6(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(BasicAmazonDeployHandler.class));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _copySourceAttributes_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "key";
                        stringArray[1] = "SUBNET_ID_OVERRIDE_TAG";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _copySourceAttributes_closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_copySourceAttributes_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _copySourceAttributes_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                String subnetIdTag = ShortTypeHandling.castToString((Object)callSiteArray[244].callGetPropertySafe(callSiteArray[245].call(callSiteArray[246].callGetProperty(callSiteArray[247].callGetProperty(serverGroup)), (Object)new _copySourceAttributes_closure6(this, this))));
                if (DefaultTypeTransformation.booleanUnbox((Object)subnetIdTag)) {
                    Object object = callSiteArray[248].call((Object)subnetIdTag, (Object)",");
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"subnetIds");
                }
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[249].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[250].call(callSiteArray[251].callGroovyObjectGetProperty((Object)description), (Object)",");
            callSiteArray[252].call(callSiteArray[253].callGroovyObjectGetProperty((Object)description), (Object)SUBNET_ID_OVERRIDE_TAG, object);
        }
        Object object = callSiteArray[254].callStatic(BasicAmazonDeployHandler.class, callSiteArray[255].callGroovyObjectGetProperty((Object)description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"tags");
        Object object2 = callSiteArray[256].callStatic(BasicAmazonDeployHandler.class, callSiteArray[257].callGroovyObjectGetProperty((Object)description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDeviceTags");
        if (!(DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[258].callGroovyObjectGetProperty((Object)description)))) {
            return description;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                throw (Throwable)callSiteArray[259].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source available");
            }
            return description;
        }
        Object object3 = callSiteArray[260].call((Object)description);
        description = (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)object3, BasicAmazonDeployDescription.class);
        Object sourceAutoScaling = callSiteArray[261].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider);
        Object ancestorAsgs = callSiteArray[262].callGetProperty(callSiteArray[263].call(sourceAutoScaling, callSiteArray[264].callConstructor(DescribeAutoScalingGroupsRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{sourceAsgName})}))));
        Object sourceAsg = callSiteArray[265].call(ancestorAsgs, (Object)0);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[266].callGetPropertySafe(sourceAsg)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[267].callGetPropertySafe(sourceAsg), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[268].callGetPropertySafe(sourceAsg), null)) {
                if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                    throw (Throwable)callSiteArray[269].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source ASG found");
                }
                return description;
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[270].callGetPropertySafe(sourceAsg)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[271].callGetPropertySafe(sourceAsg), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[272].callGetPropertySafe(sourceAsg), null)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                throw (Throwable)callSiteArray[273].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source ASG found");
            }
            return description;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
            Object object4 = callSiteArray[274].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[275].callGroovyObjectGetProperty((Object)description), (String)"min");
            Object object5 = callSiteArray[276].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[277].callGroovyObjectGetProperty((Object)description), (String)"max");
            Object object6 = callSiteArray[278].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)callSiteArray[279].callGroovyObjectGetProperty((Object)description), (String)"desired");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[280].callGroovyObjectGetProperty((Object)description))) {
            return description;
        }
        Object object7 = callSiteArray[281].callCurrent((GroovyObject)this, (Object)sourceRegionScopedProvider, sourceAsg, (Object)description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object7, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDevices");
        return description;
    }

    @VisibleForTesting
    void copyScalingPoliciesAndScheduledActions(Task task, RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, NetflixAmazonCredentials sourceCredentials, NetflixAmazonCredentials targetCredentials, String sourceAsgName, String targetAsgName, String sourceRegion, String targetRegion) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
            return;
        }
        Object asgReferenceCopier = callSiteArray[282].call((Object)sourceRegionScopedProvider, (Object)targetCredentials, (Object)targetRegion);
        callSiteArray[283].call((Object)this.scalingPolicyCopier, ArrayUtil.createArray((Object)task, (Object)sourceAsgName, (Object)targetAsgName, (Object)((Object)sourceCredentials), (Object)((Object)targetCredentials), (Object)sourceRegion, (Object)targetRegion));
        callSiteArray[284].call(asgReferenceCopier, (Object)task, (Object)sourceAsgName, (Object)targetAsgName);
    }

    @VisibleForTesting
    static List<AmazonAsgLifecycleHook> getLifecycleHooks(NetflixAmazonCredentials credentials, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object object = callSiteArray[285].callGroovyObjectGetProperty((Object)description);
        List lifecycleHooks = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[286].callGroovyObjectGetProperty((Object)description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[287].callSafe(callSiteArray[288].callGetProperty((Object)credentials)), (Object)0)) {
            public final class _getLifecycleHooks_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getLifecycleHooks_closure7(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(AmazonAsgLifecycleHook.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"roleARN", callSiteArray[1].callGetProperty(it), "notificationTargetARN", callSiteArray[2].callGetProperty(it), "lifecycleTransition", callSiteArray[3].call(AmazonAsgLifecycleHook.Transition.class, callSiteArray[4].callGetProperty(it)), "heartbeatTimeout", callSiteArray[5].callGetProperty(it), "defaultResult", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(it)) ? callSiteArray[7].call(AmazonAsgLifecycleHook.DefaultResult.class, callSiteArray[8].callGetProperty(it)) : null}));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLifecycleHooks_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "roleARN";
                    stringArray[2] = "notificationTargetARN";
                    stringArray[3] = "valueOfName";
                    stringArray[4] = "lifecycleTransition";
                    stringArray[5] = "heartbeatTimeout";
                    stringArray[6] = "defaultResult";
                    stringArray[7] = "valueOf";
                    stringArray[8] = "defaultResult";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[9];
                    _getLifecycleHooks_closure7.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getLifecycleHooks_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getLifecycleHooks_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[289].call((Object)lifecycleHooks, callSiteArray[290].call(callSiteArray[291].callGetProperty((Object)credentials), (Object)new _getLifecycleHooks_closure7(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)));
        }
        return lifecycleHooks;
    }

    @VisibleForTesting
    public static Boolean getDefaultUnlimitedCpuCredits(Set<String> instanceTypes) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[292].call(InstanceTypeUtils.class, instanceTypes)) ? Boolean.valueOf(false) : null), Boolean.class);
    }

    public static String iamRole(BasicAmazonDeployDescription description, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object object = callSiteArray[293].callGroovyObjectGetProperty((Object)description);
        Object iamRole = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[294].callGroovyObjectGetProperty((Object)deployDefaults);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[295].callGroovyObjectGetProperty((Object)description)) ? callSiteArray[296].call(iamRole, callSiteArray[297].call(Pattern.class, (Object)"{{application}}"), callSiteArray[298].callGroovyObjectGetProperty((Object)description)) : iamRole));
    }

    @VisibleForTesting
    static Map<String, String> cleanTags(Map<String, String> tags) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        public final class _cleanTags_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cleanTags_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"aws:"));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cleanTags_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "key";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _cleanTags_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cleanTags_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cleanTags_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox(tags) ? callSiteArray[299].call(tags, (Object)new _cleanTags_closure8(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)) : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class);
    }

    @VisibleForTesting
    static BasicAmazonDeployDescription applyAppStackDetailTags(AwsConfiguration.DeployDefaults deployDefaults, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[300].callGroovyObjectGetProperty((Object)deployDefaults))) {
            return description;
        }
        Object object = callSiteArray[301].call((Object)description);
        description = (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)object, BasicAmazonDeployDescription.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[302].callGroovyObjectGetProperty((Object)description))) {
            Object object2 = callSiteArray[303].callGroovyObjectGetProperty((Object)description);
            callSiteArray[304].call(callSiteArray[305].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:application", object2);
        } else {
            callSiteArray[306].call(callSiteArray[307].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:application");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[308].callGroovyObjectGetProperty((Object)description))) {
            Object object3 = callSiteArray[309].callGroovyObjectGetProperty((Object)description);
            callSiteArray[310].call(callSiteArray[311].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:stack", object3);
        } else {
            callSiteArray[312].call(callSiteArray[313].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:stack");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[314].callGroovyObjectGetProperty((Object)description))) {
            Object object4 = callSiteArray[315].callGroovyObjectGetProperty((Object)description);
            callSiteArray[316].call(callSiteArray[317].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:details", object4);
        } else {
            callSiteArray[318].call(callSiteArray[319].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:details");
        }
        return description;
    }

    private RegionScopedProviderFactory.RegionScopedProvider buildSourceRegionScopedProvider(Task task, BasicAmazonDeployDescription.Source source) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[320].callGroovyObjectGetProperty((Object)source)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[321].callGroovyObjectGetProperty((Object)source)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[322].callGroovyObjectGetProperty((Object)source))) {
            Object sourceRegion = callSiteArray[323].callGroovyObjectGetProperty((Object)source);
            Object sourceAsgCredentials = callSiteArray[324].call(this.accountCredentialsRepository, callSiteArray[325].callGroovyObjectGetProperty((Object)source));
            Object regionScopedProvider = callSiteArray[326].call((Object)this.regionScopedProviderFactory, sourceAsgCredentials, sourceRegion);
            Object sourceAsgs = callSiteArray[327].call(callSiteArray[328].callGetProperty(regionScopedProvider), callSiteArray[329].callConstructor(DescribeAutoScalingGroupsRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[330].callGroovyObjectGetProperty((Object)source)})})));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[331].callGetProperty(sourceAsgs))) {
                callSiteArray[332].call((Object)task, (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[333].callGroovyObjectGetProperty((Object)source), callSiteArray[334].callGroovyObjectGetProperty((Object)source), callSiteArray[335].callGroovyObjectGetProperty((Object)source)}, new String[]{"Unable to locate source asg (", ":", ":", ")"}));
                return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType(null, RegionScopedProviderFactory.RegionScopedProvider.class);
            }
            return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType((Object)regionScopedProvider, RegionScopedProviderFactory.RegionScopedProvider.class);
        }
        return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType(null, RegionScopedProviderFactory.RegionScopedProvider.class);
    }

    public List<AmazonBlockDevice> buildBlockDeviceMappingsFromSourceAsg(RegionScopedProviderFactory.RegionScopedProvider sourceAsgRegionScopedProvider, AutoScalingGroup sourceAsg, BasicAmazonDeployDescription newAsgDescription) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[336].callGroovyObjectGetProperty((Object)newAsgDescription), null)) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[337].callGroovyObjectGetProperty((Object)newAsgDescription), List.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[338].call((Object)newAsgDescription), (Object)callSiteArray[339].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider))) {
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure9(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", callSiteArray[0].callGetProperty(it), "virtualName", callSiteArray[1].callGetProperty(it), "size", callSiteArray[2].callGetProperty(it)});
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deviceName";
                    stringArray[1] = "virtualName";
                    stringArray[2] = "size";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _buildBlockDeviceMappingsFromSourceAsg_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure10(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "deviceName";
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object blockDevicesForSourceAsg = callSiteArray[340].call(callSiteArray[341].call(callSiteArray[342].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure9(this, this)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure10(this, this));
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure11
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure11(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", callSiteArray[0].callGetProperty(it), "virtualName", callSiteArray[1].callGetProperty(it), "size", callSiteArray[2].callGetProperty(it)});
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deviceName";
                    stringArray[1] = "virtualName";
                    stringArray[2] = "size";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _buildBlockDeviceMappingsFromSourceAsg_closure11.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure11.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure12(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "deviceName";
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure12.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object defaultBlockDevicesForSourceInsType = callSiteArray[343].call(callSiteArray[344].call(callSiteArray[345].call((Object)this.blockDeviceConfig, callSiteArray[346].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure11(this, this)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure12(this, this));
            int isDefaultMappingUsedInSourceAsg = 0;
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                boolean bl = ScriptBytecodeAdapter.compareEqual((Object)blockDevicesForSourceAsg, (Object)defaultBlockDevicesForSourceInsType);
                isDefaultMappingUsedInSourceAsg = bl ? 1 : 0;
            } else {
                boolean bl = ScriptBytecodeAdapter.compareEqual((Object)blockDevicesForSourceAsg, (Object)defaultBlockDevicesForSourceInsType);
                isDefaultMappingUsedInSourceAsg = bl ? 1 : 0;
            }
            if (isDefaultMappingUsedInSourceAsg != 0) {
                return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[347].call((Object)this.blockDeviceConfig, callSiteArray[348].call((Object)newAsgDescription)), List.class);
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[349].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider), List.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasicAmazonDeployHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = BasicAmazonDeployHandler.$getCallSiteArray()[350].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.handlers.BasicAmazonDeployHandler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "updateStatus";
        stringArray[4] = "task";
        stringArray[5] = "availabilityZones";
        stringArray[6] = "iterator";
        stringArray[7] = "availabilityZones";
        stringArray[8] = "key";
        stringArray[9] = "buildSourceRegionScopedProvider";
        stringArray[10] = "task";
        stringArray[11] = "source";
        stringArray[12] = "copySourceAttributes";
        stringArray[13] = "asgName";
        stringArray[14] = "source";
        stringArray[15] = "useSourceCapacity";
        stringArray[16] = "source";
        stringArray[17] = "value";
        stringArray[18] = "subnetType";
        stringArray[19] = "getAt";
        stringArray[20] = "loadBalancers";
        stringArray[21] = "findAll";
        stringArray[22] = "loadBalancers";
        stringArray[23] = "addAll";
        stringArray[24] = "loadBalancers";
        stringArray[25] = "name";
        stringArray[26] = "forRegion";
        stringArray[27] = "credentials";
        stringArray[28] = "getLoadBalancersByName";
        stringArray[29] = "loadBalancerLookupHelper";
        stringArray[30] = "loadBalancers";
        stringArray[31] = "unknownLoadBalancers";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "unknownLoadBalancers";
        stringArray[34] = "getTargetGroupsByName";
        stringArray[35] = "targetGroupLookupHelper";
        stringArray[36] = "targetGroups";
        stringArray[37] = "unknownTargetGroups";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "unknownTargetGroups";
        stringArray[40] = "amazonEC2";
        stringArray[41] = "describeVpcClassicLink";
        stringArray[42] = "vpcId";
        stringArray[43] = "find";
        stringArray[44] = "vpcs";
        stringArray[45] = "addAll";
        stringArray[46] = "classicLinkVpcSecurityGroups";
        stringArray[47] = "classicLinkSecurityGroupName";
        stringArray[48] = "addAll";
        stringArray[49] = "classicLinkSecurityGroupName";
        stringArray[50] = "classicLinkVpcId";
        stringArray[51] = "classicLinkVpcSecurityGroups";
        stringArray[52] = "findAll";
        stringArray[53] = "removeAll";
        stringArray[54] = "withGroupIds";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "findResults";
        stringArray[57] = "securityGroups";
        stringArray[58] = "describeSecurityGroups";
        stringArray[59] = "amazonEC2";
        stringArray[60] = "size";
        stringArray[61] = "size";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "addAll";
        stringArray[64] = "addAppGroupsToClassicLink";
        stringArray[65] = "source";
        stringArray[66] = "parseName";
        stringArray[67] = "asgName";
        stringArray[68] = "source";
        stringArray[69] = "app";
        stringArray[70] = "application";
        stringArray[71] = "remove";
        stringArray[72] = "app";
        stringArray[73] = "stack";
        stringArray[74] = "stack";
        stringArray[75] = "stack";
        stringArray[76] = "remove";
        stringArray[77] = "toString";
        stringArray[78] = "app";
        stringArray[79] = "stack";
        stringArray[80] = "detail";
        stringArray[81] = "detail";
        stringArray[82] = "freeFormDetails";
        stringArray[83] = "remove";
        stringArray[84] = "app";
        stringArray[85] = "stack";
        stringArray[86] = "detail";
        stringArray[87] = "contains";
        stringArray[88] = "application";
        stringArray[89] = "add";
        stringArray[90] = "application";
        stringArray[91] = "stack";
        stringArray[92] = "application";
        stringArray[93] = "stack";
        stringArray[94] = "contains";
        stringArray[95] = "add";
        stringArray[96] = "freeFormDetails";
        stringArray[97] = "application";
        stringArray[98] = "stack";
        stringArray[99] = "freeFormDetails";
        stringArray[100] = "contains";
        stringArray[101] = "add";
        stringArray[102] = "size";
        stringArray[103] = "maxClassicLinkSecurityGroups";
        stringArray[104] = "getSecurityGroupIds";
        stringArray[105] = "securityGroupService";
        stringArray[106] = "iterator";
        stringArray[107] = "containsKey";
        stringArray[108] = "size";
        stringArray[109] = "maxClassicLinkSecurityGroups";
        stringArray[110] = "add";
        stringArray[111] = "updateStatus";
        stringArray[112] = "task";
        stringArray[113] = "maxClassicLinkSecurityGroups";
        stringArray[114] = "toList";
        stringArray[115] = "updateStatus";
        stringArray[116] = "task";
        stringArray[117] = "find";
        stringArray[118] = "resolveAmiIdFromAllSources";
        stringArray[119] = "amiName";
        stringArray[120] = "accountId";
        stringArray[121] = "credentials";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "amiName";
        stringArray[124] = "validateCompatibility";
        stringArray[125] = "virtualizationType";
        stringArray[126] = "getAllInstanceTypes";
        stringArray[127] = "getOne";
        stringArray[128] = "name";
        stringArray[129] = "credentials";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "name";
        stringArray[132] = "credentials";
        stringArray[133] = "useAmiBlockDeviceMappings";
        stringArray[134] = "convertBlockDevices";
        stringArray[135] = "blockDeviceMappings";
        stringArray[136] = "blockDevices";
        stringArray[137] = "getBlockDevicesForInstanceType";
        stringArray[138] = "instanceType";
        stringArray[139] = "spotPrice";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "min";
        stringArray[142] = "capacity";
        stringArray[143] = "max";
        stringArray[144] = "capacity";
        stringArray[145] = "desired";
        stringArray[146] = "capacity";
        stringArray[147] = "<$constructor$>";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "application";
        stringArray[150] = "credentials";
        stringArray[151] = "stack";
        stringArray[152] = "freeFormDetails";
        stringArray[153] = "amiId";
        stringArray[154] = "min";
        stringArray[155] = "max";
        stringArray[156] = "desired";
        stringArray[157] = "securityGroups";
        stringArray[158] = "iamRole";
        stringArray[159] = "keyPair";
        stringArray[160] = "defaultKeyPair";
        stringArray[161] = "sequence";
        stringArray[162] = "ignoreSequence";
        stringArray[163] = "startDisabled";
        stringArray[164] = "associatePublicIpAddress";
        stringArray[165] = "blockDevices";
        stringArray[166] = "instanceType";
        stringArray[167] = "subnetIds";
        stringArray[168] = "classicLoadBalancers";
        stringArray[169] = "targetGroupARNs";
        stringArray[170] = "cooldown";
        stringArray[171] = "enabledMetrics";
        stringArray[172] = "healthCheckGracePeriod";
        stringArray[173] = "healthCheckType";
        stringArray[174] = "terminationPolicies";
        stringArray[175] = "spotPrice";
        stringArray[176] = "suspendedProcesses";
        stringArray[177] = "kernelId";
        stringArray[178] = "ramdiskId";
        stringArray[179] = "instanceMonitoring";
        stringArray[180] = "ebsOptimized";
        stringArray[181] = "getDefaultEbsOptimizedFlag";
        stringArray[182] = "instanceType";
        stringArray[183] = "ebsOptimized";
        stringArray[184] = "trim";
        stringArray[185] = "base64UserData";
        stringArray[186] = "legacyUdf";
        stringArray[187] = "userDataOverride";
        stringArray[188] = "tags";
        stringArray[189] = "applyAppStackDetailTags";
        stringArray[190] = "blockDeviceTags";
        stringArray[191] = "getLifecycleHooks";
        stringArray[192] = "setLaunchTemplate";
        stringArray[193] = "requireIMDSv2";
        stringArray[194] = "enableEnclave";
        stringArray[195] = "associateIPv6Address";
        stringArray[196] = "unlimitedCpuCredits";
        stringArray[197] = "unlimitedCpuCredits";
        stringArray[198] = "getDefaultUnlimitedCpuCredits";
        stringArray[199] = "getAllowedInstanceTypes";
        stringArray[200] = "placement";
        stringArray[201] = "licenseSpecifications";
        stringArray[202] = "onDemandAllocationStrategy";
        stringArray[203] = "onDemandBaseCapacity";
        stringArray[204] = "onDemandPercentageAboveBaseCapacity";
        stringArray[205] = "spotAllocationStrategy";
        stringArray[206] = "spotInstancePools";
        stringArray[207] = "launchTemplateOverridesForInstanceType";
        stringArray[208] = "capacityRebalance";
        stringArray[209] = "deploy";
        stringArray[210] = "leftShift";
        stringArray[211] = "serverGroupNames";
        stringArray[212] = "toString";
        stringArray[213] = "putAt";
        stringArray[214] = "serverGroupNameByRegion";
        stringArray[215] = "copySourceScalingPoliciesAndActions";
        stringArray[216] = "copyScalingPoliciesAndScheduledActions";
        stringArray[217] = "task";
        stringArray[218] = "amazonCredentials";
        stringArray[219] = "credentials";
        stringArray[220] = "asgName";
        stringArray[221] = "source";
        stringArray[222] = "region";
        stringArray[223] = "source";
        stringArray[224] = "leftShift";
        stringArray[225] = "events";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "ID";
        stringArray[228] = "accountId";
        stringArray[229] = "add";
        stringArray[230] = "deployments";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "getAccount";
        stringArray[233] = "updateStatus";
        stringArray[234] = "task";
        stringArray[235] = "deployments";
        stringArray[236] = "<$constructor$>";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "copySourceSubnetIdOverrides";
        stringArray[239] = "subnetIds";
        stringArray[240] = "getServerGroup";
        stringArray[241] = "name";
        stringArray[242] = "amazonCredentials";
        stringArray[243] = "region";
        stringArray[244] = "value";
        stringArray[245] = "find";
        stringArray[246] = "tags";
        stringArray[247] = "asg";
        stringArray[248] = "split";
        stringArray[249] = "subnetIds";
        stringArray[250] = "join";
        stringArray[251] = "subnetIds";
        stringArray[252] = "putAt";
        stringArray[253] = "tags";
        stringArray[254] = "cleanTags";
        stringArray[255] = "tags";
        stringArray[256] = "cleanTags";
        stringArray[257] = "blockDeviceTags";
        stringArray[258] = "copySourceCustomBlockDeviceMappings";
        stringArray[259] = "<$constructor$>";
        stringArray[260] = "clone";
        stringArray[261] = "autoScaling";
        stringArray[262] = "autoScalingGroups";
        stringArray[263] = "describeAutoScalingGroups";
        stringArray[264] = "<$constructor$>";
        stringArray[265] = "getAt";
        stringArray[266] = "launchConfigurationName";
        stringArray[267] = "launchTemplate";
        stringArray[268] = "mixedInstancesPolicy";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "launchConfigurationName";
        stringArray[271] = "launchTemplate";
        stringArray[272] = "mixedInstancesPolicy";
        stringArray[273] = "<$constructor$>";
        stringArray[274] = "minSize";
        stringArray[275] = "capacity";
        stringArray[276] = "maxSize";
        stringArray[277] = "capacity";
        stringArray[278] = "desiredCapacity";
        stringArray[279] = "capacity";
        stringArray[280] = "copySourceCustomBlockDeviceMappings";
        stringArray[281] = "buildBlockDeviceMappingsFromSourceAsg";
        stringArray[282] = "getAsgReferenceCopier";
        stringArray[283] = "copyScalingPolicies";
        stringArray[284] = "copyScheduledActionsForAsg";
        stringArray[285] = "lifecycleHooks";
        stringArray[286] = "includeAccountLifecycleHooks";
        stringArray[287] = "size";
        stringArray[288] = "lifecycleHooks";
        stringArray[289] = "addAll";
        stringArray[290] = "collect";
        stringArray[291] = "lifecycleHooks";
        stringArray[292] = "isBurstingSupportedByAllTypes";
        stringArray[293] = "iamRole";
        stringArray[294] = "iamRole";
        stringArray[295] = "application";
        stringArray[296] = "replaceAll";
        stringArray[297] = "quote";
        stringArray[298] = "application";
        stringArray[299] = "findAll";
        stringArray[300] = "addAppStackDetailTags";
        stringArray[301] = "clone";
        stringArray[302] = "application";
        stringArray[303] = "application";
        stringArray[304] = "putAt";
        stringArray[305] = "tags";
        stringArray[306] = "remove";
        stringArray[307] = "tags";
        stringArray[308] = "stack";
        stringArray[309] = "stack";
        stringArray[310] = "putAt";
        stringArray[311] = "tags";
        stringArray[312] = "remove";
        stringArray[313] = "tags";
        stringArray[314] = "freeFormDetails";
        stringArray[315] = "freeFormDetails";
        stringArray[316] = "putAt";
        stringArray[317] = "tags";
        stringArray[318] = "remove";
        stringArray[319] = "tags";
        stringArray[320] = "account";
        stringArray[321] = "region";
        stringArray[322] = "asgName";
        stringArray[323] = "region";
        stringArray[324] = "getOne";
        stringArray[325] = "account";
        stringArray[326] = "forRegion";
        stringArray[327] = "describeAutoScalingGroups";
        stringArray[328] = "autoScaling";
        stringArray[329] = "<$constructor$>";
        stringArray[330] = "asgName";
        stringArray[331] = "autoScalingGroups";
        stringArray[332] = "updateStatus";
        stringArray[333] = "account";
        stringArray[334] = "region";
        stringArray[335] = "asgName";
        stringArray[336] = "blockDevices";
        stringArray[337] = "blockDevices";
        stringArray[338] = "getInstanceType";
        stringArray[339] = "getTopLevelInstanceTypeForAsg";
        stringArray[340] = "sort";
        stringArray[341] = "collect";
        stringArray[342] = "getBlockDeviceMappingForAsg";
        stringArray[343] = "sort";
        stringArray[344] = "collect";
        stringArray[345] = "getBlockDevicesForInstanceType";
        stringArray[346] = "getTopLevelInstanceTypeForAsg";
        stringArray[347] = "getBlockDevicesForInstanceType";
        stringArray[348] = "getInstanceType";
        stringArray[349] = "getBlockDeviceMappingForAsg";
        stringArray[350] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[351];
        BasicAmazonDeployHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BasicAmazonDeployHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BasicAmazonDeployHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

